/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;

@Name(value="Numbers")
@Description(value={"All numbers between two given numbers, useful for looping.", "Use 'numbers' if your start is not an integer and you want to keep the fractional part of the start number constant, or use 'integers' if you only want to loop integers.", "An integer loop from 1 to a number x can also be written as 'loop x times'."})
@Examples(value={"loop 5 times: # loops 1, 2, 3, 4, 5", "loop numbers from 2.5 to 5.5: # loops 2.5, 3.5, 4.5, 5.5", "loop integers from 2.9 to 5.1: # same as '3 to 5', i.e. loops 3, 4, 5"})
@Since(value="1.4.6")
public class ExprNumbers
extends SimpleExpression<Number> {
    private Expression<Number> start;
    private Expression<Number> end;
    private boolean integer;

    static {
        Skript.registerExpression(ExprNumbers.class, Number.class, ExpressionType.NORMAL, "[(all|the)] (numbers|1\u00a6integers) (between|from) %number% (and|to) %number%", "%number% times");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.start = matchedPattern == 0 ? exprs[0] : new SimpleLiteral<Integer>(1, false);
        this.end = exprs[1 - matchedPattern];
        this.integer = parseResult.mark == 1 || matchedPattern == 1;
        return true;
    }

    protected Number[] get(Event e) {
        Number s = this.start.getSingle(e);
        Number f = this.end.getSingle(e);
        if (s == null || f == null || f.doubleValue() < s.doubleValue()) {
            return null;
        }
        Number[] array = this.integer ? new Integer[(int)(Math.floor(f.doubleValue()) - Math.ceil(s.doubleValue()) + 1.0)] : new Double[(int)Math.floor(f.doubleValue() - s.doubleValue() + 1.0)];
        double low = this.integer ? Math.ceil(s.doubleValue()) : s.doubleValue();
        int i = 0;
        while (i < array.length) {
            array[i] = this.integer ? (Number)((int)low + i) : (Number)(low + (double)i);
            ++i;
        }
        return array;
    }

    @Override
    public Iterator<Number> iterator(Event e) {
        Number s = this.start.getSingle(e);
        Number f = this.end.getSingle(e);
        if (s == null || f == null) {
            return null;
        }
        return new Iterator<Number>(s, f){
            double i;
            double max;
            {
                this.i = ExprNumbers.this.integer ? Math.ceil(number.doubleValue()) : number.doubleValue();
                this.max = ExprNumbers.this.integer ? Math.floor(number2.doubleValue()) : number2.doubleValue();
            }

            @Override
            public boolean hasNext() {
                return this.i <= this.max;
            }

            @Override
            public Number next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (ExprNumbers.this.integer) {
                    double d = this.i;
                    this.i = d + 1.0;
                    return (int)d;
                }
                double d = this.i;
                this.i = d + 1.0;
                return d;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.integer ? "integers" : "numbers") + " from " + this.start.toString(e, debug) + " to " + this.end.toString(e, debug);
    }

    @Override
    public boolean isLoopOf(String s) {
        return this.integer && (s.equalsIgnoreCase("integer") || s.equalsIgnoreCase("int"));
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.integer ? Integer.class : Double.class;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

