/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Utils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerLevelChangeEvent;

@Name(value="Level")
@Description(value={"The level of a player."})
@Examples(value={"reduce the victim's level by 1", "set the player's level to 0"})
@Since(value="")
public class ExprLevel
extends SimplePropertyExpression<Player, Integer> {
    static {
        ExprLevel.register(ExprLevel.class, Integer.class, "level", "players");
    }

    protected Integer[] get(Event e, Player[] source) {
        if (this.getExpr().isDefault() && e instanceof PlayerLevelChangeEvent && !Delay.isDelayed(e)) {
            return new Integer[]{this.getTime() < 0 ? ((PlayerLevelChangeEvent)e).getOldLevel() : ((PlayerLevelChangeEvent)e).getNewLevel()};
        }
        return (Integer[])super.get(e, source);
    }

    @Override
    public Integer convert(Player p) {
        return p.getLevel();
    }

    @Override
    public Class<Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public boolean setTime(int time) {
        super.setTime(time);
        return this.getExpr().isDefault() && Utils.contains(ScriptLoader.currentEvents, PlayerLevelChangeEvent.class);
    }

    @Override
    protected String getPropertyName() {
        return "level";
    }
}

