/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

@Name(value="Inventory")
@Description(value={"The inventory of a block or player. You can usually omit this expression and can directly add or remove items to/from blocks or players."})
@Examples(value={"add a plank to the player's inventory", "clear the player's inventory", "remove 5 wool from the inventory of the clicked block"})
@Since(value="1.0")
public class ExprInventory
extends SimplePropertyExpression<InventoryHolder, Inventory> {
    static {
        ExprInventory.register(ExprInventory.class, Inventory.class, "inventor(y|ies)", "inventoryholders");
    }

    @Override
    public Inventory convert(InventoryHolder h) {
        return h.getInventory();
    }

    @Override
    public Class<Inventory> getReturnType() {
        return Inventory.class;
    }

    @Override
    protected String getPropertyName() {
        return "inventor" + (this.getExpr().isSingle() ? "y" : "ies");
    }
}

