/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Creature/Entity/Player/Projectile/Villager/Powered Creeper/etc.")
@Description(value={"The entity involved in an event. A 'creature' is any living thing like a zombie, a skeleton or a player. An 'entity' is more general and can be a creature or an inanimate object like ignited TNT, a dropped item or an arrow. "})
@Examples(value={"give a diamond sword to the player", "kill the creeper", "kill all powered creepers in the wolf's world", "projectile is an arrow"})
@Since(value="1.0")
public class ExprEntity
extends SimpleExpression<Entity> {
    private EntityData<?> type;
    private EventValueExpression<Entity> entity;

    static {
        Skript.registerExpression(ExprEntity.class, Entity.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, "[the] [event-]<.+>");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            if (!StringUtils.startsWithIgnoreCase(parseResult.expr, "the ")) {
                ItemType item = Aliases.parseItemType(parseResult.regexes.get(0).group());
                if (item != null) {
                    log.stop();
                    return false;
                }
                log.clear();
            }
            this.type = EntityData.parseWithoutIndefiniteArticle(parseResult.regexes.get(0).group());
        }
        finally {
            log.stop();
        }
        if (this.type == null || this.type.isPlural()) {
            return false;
        }
        log.printLog();
        this.entity = new EventValueExpression(this.type.getType());
        this.entity.init();
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type.getType();
    }

    protected Entity[] get(Event e) {
        Entity[] es = (Entity[])this.entity.getArray(e);
        if (es.length == 0 || this.type.isInstance(es[0])) {
            return es;
        }
        return null;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the " + this.type;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

