/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.bukkit.event.Event;

@Name(value="Element of")
@Description(value={"The first, last or a random element of a set, e.g. a list variable.", "See also: <a href='#ExprRandom'>random</a>"})
@Examples(value={"give a random element out of {free items::*} to the player"})
@Since(value="2.0")
public class ExprElement
extends SimpleExpression<Object> {
    private int element;
    private Expression<?> expr;

    static {
        Skript.registerExpression(ExprElement.class, Object.class, ExpressionType.PROPERTY, "([the] first|[the] last|[a] random) element [out] of %objects%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = exprs[0];
        String e = parseResult.expr.substring(0, parseResult.expr.indexOf(32));
        if (e.equalsIgnoreCase("the") || e.equalsIgnoreCase("a")) {
            e = parseResult.expr.substring(e.length() + 1, parseResult.expr.indexOf(32, e.length()));
        }
        this.element = e.equalsIgnoreCase("last") ? 1 : (e.equalsIgnoreCase("first") ? -1 : 0);
        return true;
    }

    @Override
    protected Object[] get(Event e) {
        ?[] os;
        Object o;
        if (this.element == -1) {
            Iterator<?> iter = this.expr.iterator(e);
            if (iter == null || !iter.hasNext()) {
                return null;
            }
            o = iter.next();
        } else if (this.element == 1) {
            os = this.expr.getArray(e);
            if (os.length == 0) {
                return null;
            }
            o = os[os.length - 1];
        } else {
            os = this.expr.getArray(e);
            if (os.length == 0) {
                return null;
            }
            o = Utils.random(os);
        }
        Object[] r = (Object[])Array.newInstance(this.getReturnType(), 1);
        r[0] = o;
        return r;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.element == 0 ? "a " : "the ") + (this.element == -1 ? "first" : (this.element == 1 ? "last" : "random")) + " element of " + this.expr.toString(e, debug);
    }
}

