/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Utils;
import ch.njol.util.Math2;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Data Value")
@Description(value={"The data value of an item.", "You usually don't need this expression as you can check and set items with aliases easily, but this expression can e.g. be used to \"add 1 to data of &lt;item&gt;\", e.g. for cycling through all wool colours."})
@Examples(value={"add 1 to the data value of the clicked block"})
@Since(value="1.2")
public class ExprDurability
extends SimplePropertyExpression<ItemStack, Short> {
    static {
        ExprDurability.register(ExprDurability.class, Short.class, "((data|damage)[s] [value[s]]|durabilit(y|ies))", "itemstacks");
    }

    @Override
    public Short convert(ItemStack is) {
        return is.getDurability();
    }

    @Override
    public String getPropertyName() {
        return "data";
    }

    @Override
    public Class<Short> getReturnType() {
        return Short.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.getExpr().isSingle() && Utils.contains(this.getExpr().acceptChange(Changer.ChangeMode.SET), ItemStack.class)) {
            return Utils.array(Number.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        int a = 0;
        if (mode != Changer.ChangeMode.DELETE) {
            a = ((Number)delta).intValue();
        }
        switch (mode) {
            case REMOVE: {
                a = -a;
            }
            case ADD: {
                ItemStack is = (ItemStack)this.getExpr().getSingle(e);
                if (is == null) {
                    return;
                }
                is.setDurability((short)Math2.fit(0, is.getDurability() + a, Short.MAX_VALUE));
                this.getExpr().change(e, is, Changer.ChangeMode.SET);
                break;
            }
            case DELETE: {
                a = 0;
            }
            case SET: {
                ItemStack is2 = (ItemStack)this.getExpr().getSingle(e);
                if (is2 == null) {
                    return;
                }
                is2.setDurability((short)a);
                this.getExpr().change(e, is2, Changer.ChangeMode.SET);
            }
        }
    }
}

