/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

@Name(value="Damage")
@Description(value={"How much damage is done in a damage event, possibly ignoring armour, criticals and/or enchantments. Can be changed (remember that in Skript '1' is one full heart, not half a heart)."})
@Examples(value={"increase the damage by 2"})
@Since(value="1.3.5")
public class ExprDamage
extends SimpleExpression<Float> {
    private Kleenean delay;

    static {
        Skript.registerExpression(ExprDamage.class, Float.class, ExpressionType.SIMPLE, "[the] damage");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.containsAny(ScriptLoader.currentEvents, EntityDamageEvent.class, EntityDamageByBlockEvent.class, EntityDamageByEntityEvent.class)) {
            Skript.error("'damage' can only be used in damage events", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.delay = isDelayed;
        return true;
    }

    protected Float[] get(Event e) {
        if (!(e instanceof EntityDamageEvent)) {
            return null;
        }
        return new Float[]{Float.valueOf(0.5f * (float)((EntityDamageEvent)e).getDamage())};
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.delay != Kleenean.FALSE) {
            Skript.error("Can't change the damage anymore after the event has already passed");
            return null;
        }
        return Utils.array(Number.class);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        if (!(e instanceof EntityDamageEvent)) {
            return;
        }
        int d = mode == Changer.ChangeMode.DELETE ? 0 : Math.round(2.0f * ((Number)delta).floatValue());
        switch (mode) {
            case SET: 
            case DELETE: {
                ((EntityDamageEvent)e).setDamage(d);
                break;
            }
            case ADD: {
                ((EntityDamageEvent)e).setDamage(((EntityDamageEvent)e).getDamage() + d);
                break;
            }
            case REMOVE: {
                ((EntityDamageEvent)e).setDamage(((EntityDamageEvent)e).getDamage() - d);
            }
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Float> getReturnType() {
        return Float.class;
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the damage";
    }
}

