/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

@Name(value="Command")
@Description(value={"The command that caused an 'on command' event (excluding the leading slash and all arguments)"})
@Examples(value={"# prevent any commands except for the /exit command during some game", "on command:", "{game.%player%.is playing} is true", "command is not \"exit\"message \"You're not allowed to use commands during the game\"", "cancel the event"})
@Since(value="2.0")
public class ExprCommand
extends SimpleExpression<String> {
    static {
        Skript.registerExpression(ExprCommand.class, String.class, ExpressionType.SIMPLE, "[the] command [label]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.containsAny(ScriptLoader.currentEvents, PlayerCommandPreprocessEvent.class, ServerCommandEvent.class)) {
            Skript.error("You cannot use the 'command' expression outside of a command event");
            return false;
        }
        return true;
    }

    protected String[] get(Event e) {
        String s;
        if (e instanceof PlayerCommandPreprocessEvent) {
            s = ((PlayerCommandPreprocessEvent)e).getMessage().substring(1);
        } else if (e instanceof ServerCommandEvent) {
            s = ((ServerCommandEvent)e).getCommand();
        } else {
            return null;
        }
        int c = s.indexOf(32);
        return new String[]{c == -1 ? s : s.substring(0, c)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the command";
    }
}

