/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.event.Event;

@Name(value="Biome")
@Description(value={"The biome at a certain location. Please note that biomes are only defined for x/z-columns, i.e. the <a href='#ExprAltitude'>altitude</a> (y-coordinate) doesn't matter. "})
@Examples(value={"# damage player in deserts constantly", "every real minute:", "\tloop all players:", "\t\tbiome at loop-player is desert", "\t\tdamage the loop-player by 1"})
@Since(value="1.4.4")
public class ExprBiome
extends PropertyExpression<Location, Biome> {
    static {
        Skript.registerExpression(ExprBiome.class, Biome.class, ExpressionType.PROPERTY, "[the] biome (of|%direction%) %location%", "%location%'[s] biome");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(matchedPattern == 1 ? exprs[0] : Direction.combine(exprs[0], exprs[1]));
        return true;
    }

    protected Biome[] get(Event e, Location[] source) {
        return this.get(source, new Converter<Location, Biome>(){

            @Override
            public Biome convert(Location l) {
                return l.getWorld().getBiome(l.getBlockX(), l.getBlockZ());
            }
        });
    }

    @Override
    public Class<? extends Biome> getReturnType() {
        return Biome.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the biome at " + this.getExpr().toString(e, debug);
    }
}

