/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.events.bukkit.SkriptStartEvent;
import ch.njol.skript.events.bukkit.SkriptStopEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.event.Event;

public class EvtSkript
extends SelfRegisteringSkriptEvent {
    private boolean isStart;
    private static final Collection<Trigger> start;
    private static final Collection<Trigger> stop;

    static {
        Skript.registerEvent("Server Start/Stop", EvtSkript.class, Utils.array(SkriptStartEvent.class, SkriptStopEvent.class), "(0\u00a6server|1\u00a6skript) (start|load)", "(0\u00a6server|1\u00a6skript) stop").description("Called when the server starts or stops (actually, when Skript starts or stops, so a /reload will trigger these events as well).").examples("on Skript start", "on server stop").since("2.0");
        start = new ArrayList<Trigger>();
        stop = new ArrayList<Trigger>();
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        boolean bl = this.isStart = matchedPattern == 0;
        if (parser.mark == 0) {
            Skript.warning("Server start/stop events are actually called when Skript is started or stopped. It is thus recommended to use 'on Skript start/stop' instead.");
        }
        return true;
    }

    public static void onSkriptStart() {
        SkriptStartEvent e = new SkriptStartEvent();
        for (Trigger t : start) {
            t.execute(e);
        }
    }

    public static void onSkriptStop() {
        SkriptStopEvent e = new SkriptStopEvent();
        for (Trigger t : stop) {
            t.execute(e);
        }
    }

    @Override
    public void register(Trigger t) {
        if (this.isStart) {
            start.add(t);
        } else {
            stop.add(t);
        }
    }

    @Override
    public void unregister(Trigger t) {
        if (this.isStart) {
            start.remove(t);
        } else {
            stop.remove(t);
        }
    }

    @Override
    public void unregisterAll() {
        start.clear();
        stop.clear();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "on server " + (this.isStart ? "start" : "stop");
    }
}

