/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.events.bukkit.ScheduledEvent;
import ch.njol.skript.events.bukkit.ScheduledWorldEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.util.Timespan;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class EvtPeriodical
extends SelfRegisteringSkriptEvent {
    private Timespan period;
    private Trigger t;
    private int[] taskIDs;
    private transient World[] worlds;
    private String[] worldNames;

    static {
        Skript.registerEvent("*Periodical", EvtPeriodical.class, ScheduledEvent.class, "every %timespan%");
        Skript.registerEvent("*Periodical", EvtPeriodical.class, ScheduledWorldEvent.class, "every %timespan% in [world[s]] %worlds%").description("An event that is called periodically. The event is used like 'every &lt;<a href='../classes/#timespan'>timespan</a>&gt;', e.g. 'every second' or 'every 5 minutes'.").examples("every second", "every minecraft hour", "every tick # warning: lag!", "every minecraft day in \"world\"").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.period = (Timespan)args[0].getSingle();
        if (args.length > 1 && args[1] != null) {
            this.worlds = (World[])args[1].getArray();
            this.worldNames = new String[this.worlds.length];
            int i = 0;
            while (i < this.worlds.length) {
                this.worldNames[i] = this.worlds[i].getName();
                ++i;
            }
        }
        return true;
    }

    private void execute(World w) {
        ScheduledEvent e = w == null ? new ScheduledEvent() : new ScheduledWorldEvent(w);
        SkriptEventHandler.logEventStart(e);
        SkriptEventHandler.logTriggerStart(this.t);
        this.t.execute(e);
        SkriptEventHandler.logTriggerEnd(this.t);
        SkriptEventHandler.logEventEnd();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.worldNames != null) {
            this.worlds = new World[this.worldNames.length];
            int i = 0;
            while (i < this.worlds.length) {
                this.worlds[i] = Bukkit.getWorld((String)this.worldNames[i]);
                if (this.worlds[i] == null) {
                    throw new IOException();
                }
                ++i;
            }
        }
    }

    @Override
    public void register(Trigger t) {
        this.t = t;
        if (this.worlds == null) {
            this.taskIDs = new int[]{Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    EvtPeriodical.this.execute(null);
                }
            }, (long)this.period.getTicks(), (long)this.period.getTicks())};
        } else {
            this.taskIDs = new int[this.worlds.length];
            int i = 0;
            while (i < this.worlds.length) {
                final World w = this.worlds[i];
                this.taskIDs[i] = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        EvtPeriodical.this.execute(w);
                    }
                }, (long)this.period.getTicks() - w.getFullTime() % (long)this.period.getTicks(), (long)this.period.getTicks());
                ++i;
            }
        }
    }

    @Override
    public void unregister(Trigger t) {
        int[] nArray = this.taskIDs;
        int n = this.taskIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int taskID = nArray[n2];
            Bukkit.getScheduler().cancelTask(taskID);
            ++n2;
        }
    }

    @Override
    public void unregisterAll() {
        int[] nArray = this.taskIDs;
        int n = this.taskIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int taskID = nArray[n2];
            Bukkit.getScheduler().cancelTask(taskID);
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "every " + this.period;
    }
}

