/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import org.bukkit.Material;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityChangeBlockEvent;

public class EvtEntityBlockChange
extends SkriptEvent {
    private ChangeEvent event;

    static {
        Skript.registerEvent("Enderman/Sheep", EvtEntityBlockChange.class, EntityChangeBlockEvent.class, ChangeEvent.patterns).description("Called when an enderman places or picks up a block, or a sheep eats grass respectively.").examples("").since("");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.event = ChangeEvent.values()[matchedPattern];
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (!(e instanceof EntityChangeBlockEvent)) {
            return false;
        }
        return this.event.checker.check((EntityChangeBlockEvent)e);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return this.event.name().toLowerCase();
    }

    private static enum ChangeEvent {
        ENDERMAN_PLACE("enderman place", new Checker<EntityChangeBlockEvent>(){

            @Override
            public boolean check(EntityChangeBlockEvent e) {
                return e.getEntity() instanceof Enderman && e.getTo() != Material.AIR;
            }
        }),
        ENDERMAN_PICKUP("enderman pickup", new Checker<EntityChangeBlockEvent>(){

            @Override
            public boolean check(EntityChangeBlockEvent e) {
                return e.getEntity() instanceof Enderman && e.getTo() == Material.AIR;
            }
        }),
        SHEEP_EAT("sheep eat", new Checker<EntityChangeBlockEvent>(){

            @Override
            public boolean check(EntityChangeBlockEvent e) {
                return e.getEntity() instanceof Sheep;
            }
        });

        private final String pattern;
        final Checker<EntityChangeBlockEvent> checker;
        static String[] patterns;

        static {
            patterns = new String[ChangeEvent.values().length];
            int i = 0;
            while (i < patterns.length) {
                ChangeEvent.patterns[i] = ChangeEvent.values()[i].pattern;
                ++i;
            }
        }

        private ChangeEvent(String pattern, Checker<EntityChangeBlockEvent> c) {
            this.pattern = pattern;
            this.checker = c;
        }
    }
}

