/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public final class EvtEntity
extends SkriptEvent {
    private EntityData<?>[] types;

    static {
        Skript.registerEvent("Death", EvtEntity.class, Utils.array(EntityDeathEvent.class, PlayerDeathEvent.class), "death [of %entitydatas%]").description("Called when a living entity (including players) dies.").examples("on death", "on death of player", "on death of a wither or ender dragon:", "\tbroadcast \"A %entity% has been slain in %world%!\"").since("1.0");
        Skript.registerEvent("Spawn", EvtEntity.class, CreatureSpawnEvent.class, "spawn[ing] [of %entitydatas%]").description("Called when an creature spawns.").examples("on spawn of a zombie", "on spawn of an ender dragon:", "\tbroadcast \"A dragon has been sighted in %world%!\"").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        block6: {
            EntityData[] entityDataArray = this.types = args[0] == null ? null : (EntityData[])args[0].getAll();
            if (this.types == null) break block6;
            if (StringUtils.startsWithIgnoreCase(parser.expr, "spawn")) {
                EntityData<?>[] entityDataArray2 = this.types;
                int n = this.types.length;
                int n2 = 0;
                while (n2 < n) {
                    EntityData<?> d = entityDataArray2[n2];
                    if (!Creature.class.isAssignableFrom(d.getType())) {
                        Skript.error("The spawn event only works for creatures", ErrorQuality.SEMANTIC_ERROR);
                        return false;
                    }
                    ++n2;
                }
            } else {
                EntityData<?>[] entityDataArray3 = this.types;
                int n = this.types.length;
                int n3 = 0;
                while (n3 < n) {
                    EntityData<?> d = entityDataArray3[n3];
                    if (!LivingEntity.class.isAssignableFrom(d.getType())) {
                        Skript.error("The death event only works for living entities", ErrorQuality.SEMANTIC_ERROR);
                        return false;
                    }
                    ++n3;
                }
            }
        }
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (this.types == null) {
            return true;
        }
        LivingEntity en = e instanceof EntityDeathEvent ? ((EntityDeathEvent)e).getEntity() : ((CreatureSpawnEvent)e).getEntity();
        EntityData<?>[] entityDataArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            EntityData<?> d = entityDataArray[n2];
            if (d.isInstance((Entity)en)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "death/spawn" + (this.types == null ? "" : " of " + Classes.toString(this.types, false));
    }
}

