/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.StringUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class EvtClick
extends SkriptEvent {
    private static final long serialVersionUID = -5935656107417409014L;
    private Literal<?> types = null;
    private Literal<ItemType> tools;
    private static final int RIGHT = 1;
    private static final int LEFT = 2;
    private static final int ANY = 3;
    private int click = 3;

    static {
        Skript.registerEvent("Click", EvtClick.class, Utils.array(PlayerInteractEvent.class, PlayerInteractEntityEvent.class), "[(left|right)[ ]][mouse[ ]]click[ing] [on %-entitydata/itemtype%] [(with|using|holding) %itemtype%]", "[(left|right)[ ]][mouse[ ]]click[ing] (with|using|holding) %itemtype% on %entitydata/itemtype%").description("Called when a user clicks on a block, an entity or air with or without an item in their hand.", "Please note that rightclick events with an empty hand are not sent to the server, so there's no way to detect them.").examples("on click", "on rightclick holding a fishing rod", "on leftclick on a stone or obsidian", "on rightclick on a creeper", "on click with a sword").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        if (StringUtils.startsWithIgnoreCase(parser.expr, "right")) {
            this.click = 1;
        } else if (StringUtils.startsWithIgnoreCase(parser.expr, "left")) {
            this.click = 2;
        }
        this.types = args[matchedPattern];
        if (this.types != null && !ItemType.class.isAssignableFrom(this.types.getReturnType())) {
            if (this.click == 2) {
                Skript.error("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event.", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            if (this.click == 3) {
                Skript.warning("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event. Change this event to a rightclick to disable this warning message.");
            }
        }
        this.tools = args[1 - matchedPattern];
        return true;
    }

    @Override
    public boolean check(Event e) {
        Block block;
        Entity entity;
        Player player;
        if (e instanceof PlayerInteractEntityEvent) {
            if (this.click == 2 || this.types == null) {
                return false;
            }
            player = ((PlayerInteractEntityEvent)e).getPlayer();
            entity = ((PlayerInteractEntityEvent)e).getRightClicked();
            block = null;
        } else if (e instanceof PlayerInteractEvent) {
            if (this.click == 2 && ((PlayerInteractEvent)e).getAction() != Action.LEFT_CLICK_AIR && ((PlayerInteractEvent)e).getAction() != Action.LEFT_CLICK_BLOCK) {
                return false;
            }
            if (this.click == 1 && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_AIR && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_BLOCK) {
                return false;
            }
            player = ((PlayerInteractEvent)e).getPlayer();
            block = ((PlayerInteractEvent)e).getClickedBlock();
            entity = null;
        } else {
            assert (false);
            return false;
        }
        if (this.tools != null && !this.tools.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(player.getItemInHand());
            }
        })) {
            return false;
        }
        if (this.types == null) {
            return true;
        }
        return this.types.check(e, new Checker<Object>(){

            @Override
            public boolean check(Object o) {
                return o instanceof EntityData ? ((EntityData)o).isInstance(entity) : ((ItemType)o).isOfType(block);
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.click == 2 ? "left" : (this.click == 1 ? "right" : "")) + "click" + (this.types == null ? "" : " on " + this.types.toString(e, debug)) + (this.tools == null ? "" : " holding " + this.tools.toString(e, debug));
    }
}

