/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.StringUtils;
import org.bukkit.Location;
import org.bukkit.entity.ExperienceOrb;

public class XpOrbData
extends EntityData<ExperienceOrb> {
    private int xp = -1;
    private boolean plural;

    static {
        XpOrbData.register(XpOrbData.class, "xporb", ExperienceOrb.class, "([e]xp|experience)( |-)orb[s]");
    }

    public XpOrbData() {
    }

    public XpOrbData(int xp) {
        this.xp = xp;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.plural = StringUtils.endsWithIgnoreCase(parseResult.expr, "s");
        return true;
    }

    @Override
    public Class<? extends ExperienceOrb> getType() {
        return ExperienceOrb.class;
    }

    @Override
    protected boolean match(ExperienceOrb entity) {
        return this.xp == -1 || entity.getExperience() == this.xp;
    }

    @Override
    public void set(ExperienceOrb entity) {
        if (this.xp != -1) {
            entity.setExperience(this.xp);
        }
    }

    @Override
    public ExperienceOrb spawn(Location loc) {
        ExperienceOrb orb = (ExperienceOrb)super.spawn(loc);
        if (this.xp == -1) {
            orb.setExperience(1);
        }
        return orb;
    }

    @Override
    public String toString() {
        return this.xp == -1 ? "experience orb" : String.valueOf(this.xp) + "-xp orb";
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    public int getExperience() {
        return this.xp == -1 ? 1 : this.xp;
    }

    public int getInternExperience() {
        return this.xp;
    }

    @Override
    public int hashCode() {
        return this.xp;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XpOrbData)) {
            return false;
        }
        XpOrbData other = (XpOrbData)obj;
        return this.xp == other.xp;
    }

    @Override
    public String serialize() {
        return "" + this.xp;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.xp = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected boolean isSupertypeOf_i(EntityData<? extends ExperienceOrb> e) {
        if (e instanceof XpOrbData) {
            return this.xp == -1 || ((XpOrbData)e).xp == this.xp;
        }
        return false;
    }
}

