/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.StringUtils;
import org.bukkit.entity.Skeleton;

public class SkeletonData
extends EntityData<Skeleton> {
    private boolean wither;
    private boolean plural;

    static {
        if (Skript.isRunningMinecraft(1, 4)) {
            SkeletonData.register(SkeletonData.class, "skeleton", Skeleton.class, "skeleton[s]", "wither skeleton[s]");
        } else {
            SkeletonData.register(SkeletonData.class, "skeleton", Skeleton.class, "skeleton[s]");
        }
    }

    public boolean isWither() {
        return this.wither;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.wither = matchedPattern == 1;
        this.plural = StringUtils.endsWithIgnoreCase(parseResult.expr, "s");
        return true;
    }

    @Override
    public String serialize() {
        return this.wither ? "1" : "0";
    }

    @Override
    protected boolean deserialize(String s) {
        if (s.equals("1")) {
            this.wither = true;
        } else if (s.equals("0")) {
            this.wither = false;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void set(Skeleton entity) {
        entity.setSkeletonType(this.wither ? Skeleton.SkeletonType.WITHER : Skeleton.SkeletonType.NORMAL);
    }

    @Override
    protected boolean match(Skeleton entity) {
        return entity.getSkeletonType() == Skeleton.SkeletonType.WITHER == this.wither;
    }

    @Override
    public Class<? extends Skeleton> getType() {
        return Skeleton.class;
    }

    @Override
    public String toString() {
        return this.wither ? "wither skeleton" : "skeleton";
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkeletonData)) {
            return false;
        }
        SkeletonData other = (SkeletonData)obj;
        return other.wither == this.wither;
    }

    @Override
    public int hashCode() {
        return this.wither ? 1 : 0;
    }

    @Override
    protected boolean isSupertypeOf_i(EntityData<? extends Skeleton> e) {
        if (e instanceof SkeletonData) {
            return ((SkeletonData)e).wither == this.wither;
        }
        return false;
    }
}

