/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.StringUtils;
import java.util.Arrays;
import org.bukkit.entity.Sheep;

public class SheepData
extends EntityData<Sheep> {
    private Color[] colors = null;
    private int sheared = 0;
    private boolean plural;

    static {
        EntityData.register(SheepData.class, "sheep", Sheep.class, "(un|non[-])sheared [%-colors%] sheep[s]", "[%-colors%] sheep[s]", "sheared [%-colors%] sheep[s]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.sheared = matchedPattern - 1;
        if (exprs[0] != null) {
            this.colors = (Color[])exprs[0].getAll();
        }
        this.plural = StringUtils.endsWithIgnoreCase(parseResult.expr, "s");
        return true;
    }

    @Override
    public void set(Sheep entity) {
        if (this.colors != null) {
            entity.setColor(Utils.random(this.colors).getWoolColor());
        }
    }

    @Override
    public boolean match(final Sheep entity) {
        return !(this.sheared != 0 && entity.isSheared() != (this.sheared == 1) || this.colors != null && !SimpleExpression.check(this.colors, new Checker<Color>(){

            @Override
            public boolean check(Color c) {
                return entity.getColor() == c.getWoolColor();
            }
        }, false, false));
    }

    @Override
    public Class<Sheep> getType() {
        return Sheep.class;
    }

    @Override
    public String toString() {
        return String.valueOf(this.sheared == -1 ? "unsheared " : (this.sheared == 1 ? "sheared " : "")) + (this.colors == null ? "" : String.valueOf(Classes.toString((Object[])this.colors, false)) + " ") + "sheep";
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.colors);
        result = 31 * result + this.sheared;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheepData)) {
            return false;
        }
        SheepData other = (SheepData)obj;
        if (!Arrays.equals((Object[])this.colors, (Object[])other.colors)) {
            return false;
        }
        return this.sheared == other.sheared;
    }

    @Override
    public String serialize() {
        if (this.colors != null) {
            StringBuilder b = new StringBuilder();
            b.append(this.sheared);
            b.append("|");
            Color[] colorArray = this.colors;
            int n = this.colors.length;
            int n2 = 0;
            while (n2 < n) {
                Color c = colorArray[n2];
                if (b.length() != 0) {
                    b.append(",");
                }
                b.append(c.name());
                ++n2;
            }
            return b.toString();
        }
        return "" + this.sheared;
    }

    @Override
    protected boolean deserialize(String s) {
        String sh;
        String[] split = s.split("\\|");
        if (split.length == 1) {
            sh = s;
        } else if (split.length == 2) {
            sh = split[0];
            String[] cs = split[1].split(",");
            this.colors = new Color[cs.length];
            int i = 0;
            while (i < cs.length) {
                try {
                    this.colors[i] = Color.valueOf(cs[i]);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        try {
            this.sheared = Integer.parseInt(sh);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected boolean isSupertypeOf_i(EntityData<? extends Sheep> e) {
        if (e instanceof SheepData) {
            return this.colors == null || Utils.isSubset((Object[])this.colors, (Object[])((SheepData)e).colors);
        }
        return false;
    }
}

