/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.StringUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlayerData
extends EntityData<Player> {
    int op = 0;
    private boolean plural;

    static {
        EntityData.register(PlayerData.class, "player", Player.class, "non-op[s]", "player[s]", "op[s]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.op = matchedPattern - 1;
        this.plural = StringUtils.endsWithIgnoreCase(parseResult.expr, "s");
        return true;
    }

    @Override
    public void set(Player p) {
        if (this.op != 0) {
            p.setOp(this.op == 1);
        }
    }

    @Override
    protected boolean match(Player p) {
        return this.op == 0 || p.isOp() == (this.op == 1);
    }

    @Override
    public Class<? extends Player> getType() {
        return Player.class;
    }

    @Override
    public String toString() {
        return this.op == -1 ? "non-op" : (this.op == 1 ? "op" : "player");
    }

    @Override
    public Player spawn(Location loc) {
        return null;
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    @Override
    public int hashCode() {
        return this.op;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerData)) {
            return false;
        }
        PlayerData other = (PlayerData)obj;
        return this.op == other.op;
    }

    @Override
    public String serialize() {
        return "" + this.op;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.op = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected boolean isSupertypeOf_i(EntityData<? extends Player> e) {
        if (e instanceof PlayerData) {
            return this.op == 0 || ((PlayerData)e).op == this.op;
        }
        return false;
    }
}

