/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.StringUtils;
import org.bukkit.entity.Pig;

public class PigData
extends EntityData<Pig> {
    private int saddled;
    private boolean plural;

    static {
        PigData.register(PigData.class, "pig", Pig.class, "unsaddled pig[s]", "pig[s]", "saddled pig[s]");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.saddled = matchedPattern - 1;
        this.plural = StringUtils.endsWithIgnoreCase(parseResult.expr, "s");
        return true;
    }

    @Override
    public String serialize() {
        return "" + this.saddled;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.saddled = Integer.parseInt(s);
            return Math.abs(this.saddled) <= 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void set(Pig entity) {
        if (this.saddled != 0) {
            entity.setSaddle(this.saddled == 1);
        }
    }

    @Override
    protected boolean match(Pig entity) {
        return this.saddled == 0 || entity.hasSaddle() == (this.saddled == 1);
    }

    @Override
    public Class<? extends Pig> getType() {
        return Pig.class;
    }

    @Override
    public String toString() {
        return String.valueOf(this.saddled == 1 ? "saddled " : (this.saddled == -1 ? "unsaddled " : "")) + "pig";
    }

    @Override
    public boolean isPlural() {
        return this.plural;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PigData)) {
            return false;
        }
        PigData other = (PigData)obj;
        return other.saddled == this.saddled;
    }

    @Override
    public int hashCode() {
        return this.saddled;
    }

    @Override
    protected boolean isSupertypeOf_i(EntityData<? extends Pig> e) {
        if (e instanceof PigData) {
            return this.saddled == 0 || ((PigData)e).saddled == this.saddled;
        }
        return false;
    }
}

