/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.entity.PlayerData;
import ch.njol.skript.entity.SimpleEntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class EntityData<E extends Entity>
implements SyntaxElement {
    private static final List<EntityDataInfo<?>> infos = new ArrayList();
    public static Serializer<EntityData> serializer = new Serializer<EntityData>(){

        @Override
        public String serialize(EntityData d) {
            return String.valueOf(EntityData.getInfo(d.getClass()).codeName) + ":" + d.serialize();
        }

        @Override
        public EntityData deserialize(String s) {
            EntityData d;
            String[] split = s.split(":", 2);
            if (split.length != 2) {
                return null;
            }
            EntityDataInfo<?> i = EntityData.getInfo(split[0]);
            if (i == null) {
                return null;
            }
            try {
                d = (EntityData)i.c.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (!d.deserialize(s)) {
                return null;
            }
            return d;
        }
    };

    static {
        Classes.registerClass(new ClassInfo<EntityData>(EntityData.class, "entitydata").user("entity ?types?").name("Entity Type").description("The type of an <a href='#entity'>entity</a>, e.g. player, wolf, powered creeper, etc.").usage("<i>Detailled usage will be added eventually</i>").examples("victim is a cow", "spawn a creeper").since("1.3").defaultExpression(new SimpleLiteral<SimpleEntityData>(new SimpleEntityData(Entity.class), true)).before("entitytype").parser((Parser<SimpleEntityData>)new Parser<EntityData>(){

            @Override
            public String toString(EntityData d) {
                return d.toString();
            }

            @Override
            public EntityData parse(String s, ParseContext context) {
                return EntityData.parse(s);
            }

            @Override
            public String toVariableNameString(EntityData o) {
                return "entitydata:" + o.toString();
            }

            @Override
            public String getVariableNamePattern() {
                return "entitydata:.+";
            }
        }).serializer(serializer));
    }

    static <E extends Entity, T extends EntityData<E>> void register(Class<T> dataClass, String name, Class<E> entityClass, String ... patterns) throws IllegalArgumentException {
        EntityDataInfo<T> info = new EntityDataInfo<T>(dataClass, name, entityClass, patterns);
        int i = 0;
        while (i < infos.size()) {
            if (EntityData.infos.get((int)i).entityClass.isAssignableFrom(entityClass)) {
                infos.add(i, info);
                return;
            }
            ++i;
        }
        infos.add(info);
    }

    public static final EntityDataInfo<?> getInfo(Class<? extends EntityData<?>> c) {
        for (EntityDataInfo<?> i : infos) {
            if (i.c != c) continue;
            return i;
        }
        throw new SkriptAPIException("Unregistered EntityData class " + c.getName());
    }

    public static final EntityDataInfo<?> getInfo(String codeName) {
        for (EntityDataInfo<?> i : infos) {
            if (!i.codeName.equals(codeName)) continue;
            return i;
        }
        return null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return this.init((Literal[])Arrays.copyOf(exprs, exprs.length, Literal[].class), matchedPattern, parseResult);
    }

    public static final EntityData<?> parse(String s) {
        return (EntityData)SkriptParser.parseStatic(Noun.stripIndefiniteArticle(s), infos.iterator(), null);
    }

    public static final EntityData<?> parseWithoutIndefiniteArticle(String s) {
        return (EntityData)SkriptParser.parseStatic(s, infos.iterator(), null);
    }

    public E spawn(Location loc) {
        assert (loc != null);
        try {
            Entity e = loc.getWorld().spawn(loc, this.getType());
            this.set(e);
            return (E)e;
        }
        catch (IllegalArgumentException e) {
            if (Skript.testing()) {
                Skript.error("Can't spawn " + this.getType().getName());
            }
            return null;
        }
    }

    public E[] getAll(World ... worlds) {
        assert (worlds != null && worlds.length > 0) : Arrays.toString(worlds);
        ArrayList<Entity> list = new ArrayList<Entity>();
        World[] worldArray = worlds;
        int n = worlds.length;
        int n2 = 0;
        while (n2 < n) {
            World w = worldArray[n2];
            for (Entity e : w.getEntitiesByClass(this.getType())) {
                if (!this.match(e)) continue;
                list.add(e);
            }
            ++n2;
        }
        return list.toArray((Entity[])Array.newInstance(this.getType(), list.size()));
    }

    public static final <E extends Entity> E[] getAll(EntityData<?>[] types, Class<E> type, World[] worlds) {
        assert (types.length > 0);
        if (type == Player.class) {
            if (worlds == null && types.length == 1 && types[0] instanceof PlayerData && ((PlayerData)types[0]).op == 0) {
                return Bukkit.getOnlinePlayers();
            }
            ArrayList<Player> list = new ArrayList<Player>();
            Player[] playerArray = Bukkit.getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                if (worlds == null || Utils.contains(worlds, p.getWorld())) {
                    EntityData<?>[] entityDataArray = types;
                    int n3 = types.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        EntityData<?> t = entityDataArray[n4];
                        if (t.isInstance((Entity)p)) {
                            list.add(p);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return (Entity[])list.toArray(new Player[list.size()]);
        }
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (worlds == null) {
            worlds = Bukkit.getWorlds().toArray(new World[0]);
        }
        World[] worldArray = worlds;
        int n = worlds.length;
        int n5 = 0;
        while (n5 < n) {
            World w = worldArray[n5];
            block3: for (Entity e : w.getEntitiesByClass(type)) {
                EntityData<?>[] entityDataArray = types;
                int n6 = types.length;
                int n7 = 0;
                while (n7 < n6) {
                    EntityData<?> t = entityDataArray[n7];
                    if (t.isInstance(e)) {
                        list.add(e);
                        continue block3;
                    }
                    ++n7;
                }
            }
            ++n5;
        }
        return list.toArray((Entity[])Array.newInstance(type, list.size()));
    }

    public static <E extends Entity> EntityData<? super E> fromClass(Class<E> c) {
        assert (c != null);
        if (!c.isInterface()) {
            Class<?>[] classArray = c.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                if (Entity.class.isAssignableFrom(i)) {
                    return EntityData.fromClass(i);
                }
                ++n2;
            }
            return null;
        }
        for (EntityDataInfo<?> info : infos) {
            if (info.entityClass == Entity.class || !info.entityClass.isAssignableFrom(c)) continue;
            try {
                return (EntityData)info.c.newInstance();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, new String[0]);
                return null;
            }
        }
        return new SimpleEntityData(c);
    }

    public static <E extends Entity> EntityData<? super E> fromEntity(E e) {
        return EntityData.fromClass(e.getClass());
    }

    public static final String toString(Entity e) {
        return EntityData.fromEntity(e).toString();
    }

    public static final String toString(Class<? extends Entity> c) {
        return EntityData.fromClass(c).toString();
    }

    public final boolean isInstance(Entity e) {
        if (e == null) {
            return false;
        }
        return this.getType().isInstance(e) && this.match(e);
    }

    public boolean isSupertypeOf(EntityData<?> e) {
        if (!this.getType().isAssignableFrom(e.getType())) {
            return false;
        }
        return this.isSupertypeOf_i(e);
    }

    protected abstract boolean isSupertypeOf_i(EntityData<? extends E> var1);

    public abstract String serialize();

    protected abstract boolean deserialize(String var1);

    protected abstract boolean init(Literal<?>[] var1, int var2, SkriptParser.ParseResult var3);

    public abstract void set(E var1);

    protected abstract boolean match(E var1);

    public abstract Class<? extends E> getType();

    public abstract String toString();

    public abstract boolean isPlural();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static final class EntityDataInfo<T extends EntityData<?>>
    extends SyntaxElementInfo<T> {
        final String codeName;
        final Class<? extends Entity> entityClass;

        public EntityDataInfo(Class<T> dataClass, String codeName, Class<? extends Entity> entityClass, String[] patterns) throws IllegalArgumentException {
            super(patterns, dataClass);
            this.codeName = codeName;
            this.entityClass = entityClass;
        }
    }
}

