/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

@Name(value="Vehicle")
@Description(value={"Makes an entity ride another entity, e.g. a minecart, a saddled pig, an arrow, etc."})
@Examples(value={"make the player ride a saddled pig", "make the attacker ride the victim"})
@Since(value="2.0")
public class EffVehicle
extends Effect {
    private Expression<Entity> passenger;
    private Expression<?> vehicle;

    static {
        Skript.registerEffect(EffVehicle.class, "make %entity% ride [(in|on)] %entity/entitydata%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.passenger = exprs[0];
        this.vehicle = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Object v = this.vehicle.getSingle(e);
        if (v == null) {
            return;
        }
        Entity p = this.passenger.getSingle(e);
        if (p == null) {
            return;
        }
        if (v instanceof Entity) {
            ((Entity)v).setPassenger(p);
        } else {
            Object en = ((EntityData)v).spawn(p.getLocation());
            if (en == null) {
                return;
            }
            en.setPassenger(p);
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "make " + this.passenger.toString(e, debug) + " ride " + this.vehicle.toString(e, debug);
    }
}

