/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Lightning")
@Description(value={"Strike lightning at a given location. Can use 'ligning effect' to create a lightning that does not harm entities or start fires."})
@Examples(value={"strike lightning at the player", "strike lightning effect at the victim"})
@Since(value="1.4")
public class EffLightning
extends Effect {
    private Expression<Location> locations;
    private boolean effectOnly;

    static {
        Skript.registerEffect(EffLightning.class, "(create|strike) lightning %directions% %locations%", "(create|strike) lightning[ ]effect %directions% %locations%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.locations = Direction.combine(exprs[0], exprs[1]);
        this.effectOnly = matchedPattern == 1;
        return true;
    }

    @Override
    protected void execute(Event e) {
        Location[] locationArray = this.locations.getArray(e);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            if (this.effectOnly) {
                l.getWorld().strikeLightningEffect(l);
            } else {
                l.getWorld().strikeLightning(l);
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "strike lightning " + (this.effectOnly ? "effect " : "") + this.locations.toString(e, debug);
    }
}

