/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

@Name(value="Kill")
@Description(value={"Kills an entity.", "Note: This effect does not set the entitie's health to 0 (which causes issues), but damages the entity by 100 times its maximum health."})
@Examples(value={"kill the player", "kill all creepers in the player's world", "kill all endermen, witches and bats"})
@Since(value="1.0")
public class EffKill
extends Effect {
    private Expression<Entity> entities;

    static {
        Skript.registerEffect(EffKill.class, "kill %entities%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).damage(((LivingEntity)entity).getMaxHealth() * 100);
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "kill " + this.entities.toString(e, debug);
    }
}

