/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Kick")
@Description(value={"Kicks a player from the server."})
@Examples(value={"on place of TNT, lava, or obsidian:", "\tkick the player due to \"You may not place %block%!\"", "\tcancel the event"})
@Since(value="1.0")
public class EffKick
extends Effect {
    private Expression<Player> players;
    private Expression<String> reason;

    static {
        Skript.registerEffect(EffKick.class, "kick %players% [(by reason of|because [of]|on account of|due to) %-string%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.reason = exprs[1];
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "kick " + this.players.toString(e, debug) + (this.reason == null ? "" : " on account of " + this.reason.toString(e, debug));
    }

    @Override
    protected void execute(Event e) {
        String r = this.reason == null ? null : this.reason.getSingle(e);
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            p.kickPlayer(r);
            ++n2;
        }
    }
}

