/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Explosion")
@Description(value={"Creates an explosion of a given force. The Minecraft Wiki has an <a href='http://www.minecraftwiki.net/wiki/Explosion'>article on explosions</a> which contains the explosion forces of TNT, creepers, etc.", "Hint: use a force of 0 to create a fake explosion that does not damage whatsoever."})
@Examples(value={"create an explosion of force 10 at the player", "create an explosion of force 0 at the victim"})
@Since(value="1.0")
public class EffExplosion
extends Effect {
    private Expression<Number> force;
    private Expression<Location> locations;

    static {
        Skript.registerEffect(EffExplosion.class, "[create] [an] explosion (of|with) (force|strength|power) %number% [%directions% %locations%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.force = exprs[0];
        this.locations = Direction.combine(exprs[1], exprs[2]);
        return true;
    }

    @Override
    public void execute(Event e) {
        Number power = this.force.getSingle(e);
        if (power == null) {
            return;
        }
        Location[] locationArray = this.locations.getArray(e);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            l.getWorld().createExplosion(l, power.floatValue());
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "create explosion of force " + this.force.toString(e, debug) + " " + this.locations.toString(e, debug);
    }
}

