/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

@Name(value="Drop")
@Description(value={"Drops one or more items."})
@Examples(value={"on death of creeper:", "\tdrop 1 TNT"})
@Since(value="1.0")
public class EffDrop
extends Effect {
    private Expression<Experience> xp = null;
    private Expression<ItemType> items = null;
    private Expression<Location> locations;

    static {
        Skript.registerEffect(EffDrop.class, "drop %experience% [%directions% %locations%]", "drop %itemtypes% [%directions% %locations%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (matchedPattern == 0) {
            this.xp = exprs[0];
        } else {
            this.items = exprs[0];
        }
        this.locations = Direction.combine(exprs[1], exprs[2]);
        return true;
    }

    @Override
    public void execute(Event e) {
        ItemType[] types;
        ItemType[] itemTypeArray = types = this.items == null ? null : this.items.getArray(e);
        if (e instanceof EntityDeathEvent && ((EntityDeathEvent)e).getEntity().getLocation().equals((Object)this.locations.getSingle(e)) && !Delay.isDelayed(e)) {
            if (this.xp != null) {
                Experience exp = this.xp.getSingle(e);
                if (exp != null) {
                    ((EntityDeathEvent)e).setDroppedExp(((EntityDeathEvent)e).getDroppedExp() + exp.getXP());
                }
                return;
            }
            ItemType[] itemTypeArray2 = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType type = itemTypeArray2[n2];
                type.addTo(((EntityDeathEvent)e).getDrops());
                ++n2;
            }
            return;
        }
        Location[] locationArray = this.locations.getArray(e);
        int n = locationArray.length;
        int n3 = 0;
        while (n3 < n) {
            Location l = locationArray[n3];
            if (this.xp != null) {
                Experience exp = this.xp.getSingle(e);
                if (exp != null) {
                    ExperienceOrb orb = (ExperienceOrb)l.getWorld().spawn(l, ExperienceOrb.class);
                    orb.setExperience(exp.getXP());
                }
            } else {
                ItemType[] itemTypeArray3 = types;
                int n4 = types.length;
                int n5 = 0;
                while (n5 < n4) {
                    ItemType type = itemTypeArray3[n5];
                    for (ItemStack is : type.getItem().getAll()) {
                        if (is.getTypeId() == 0) continue;
                        l.getWorld().dropItemNaturally(l, is);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "drop " + this.items.toString(e, debug) + " " + this.locations.toString(e, debug);
    }
}

