/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.SerializableChanger;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.event.Event;

@Name(value="Change: Set/Add/Remove/Delete")
@Description(value={"A very general effect that can change many <a href='../expressions'>expressions</a>. Many expressions can only be set and/or deleted, while some can have things added to or removed from them."})
@Examples(value={"# set:", "Set the player's display name to \"<red>%name of player%\"", "set the block above the victim to lava", "# add:", "add 2 to the player's health # preferably use '<a href='#heal'>heal</a>' for this", "add argument to {blacklist::*}", "give a diamond pickaxe of efficiency 5 to the player", "increase the datavalue of the clicked block by 1", "# remove:", "remove 2 pickaxes from the victim", "remove all iron tools from the targeted block", "subtract 2.5 from {points.%player%}", "# delete:", "delete the block below the player", "clear drops", "delete {variable}"})
@Since(value="1.0")
public class EffChange
extends Effect {
    private static Patterns<Changer.ChangeMode> patterns = new Patterns(new Object[][]{{"(add|give) %objects% to %~objects%", Changer.ChangeMode.ADD}, {"increase %~objects% by %objects%", Changer.ChangeMode.ADD}, {"give %~objects% %objects%", Changer.ChangeMode.ADD}, {"set %~objects% to %objects%", Changer.ChangeMode.SET}, {"(remove|subtract) %objects% from %~objects%", Changer.ChangeMode.REMOVE}, {"reduce %~objects% by %objects%", Changer.ChangeMode.REMOVE}, {"(clear|delete) %~objects%", Changer.ChangeMode.DELETE}});
    private Expression<?> changed;
    private Expression<?> changer = null;
    private Changer.ChangeMode mode;
    private boolean single = true;

    static {
        Skript.registerEffect(EffChange.class, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        String what;
        Object[] rs;
        this.mode = patterns.getInfo(matchedPattern);
        switch (this.mode) {
            case ADD: {
                if (matchedPattern == 0) {
                    this.changer = exprs[0];
                    this.changed = exprs[1];
                    break;
                }
                this.changed = exprs[0];
                this.changer = exprs[1];
                break;
            }
            case SET: {
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case REMOVE: {
                if (matchedPattern == 4) {
                    this.changer = exprs[0];
                    this.changed = exprs[1];
                    break;
                }
                this.changed = exprs[0];
                this.changer = exprs[1];
                break;
            }
            case DELETE: {
                this.changed = exprs[0];
                break;
            }
            default: {
                assert (false);
                return false;
            }
        }
        CountingLogHandler h = SkriptLogger.startLogHandler(new CountingLogHandler(Level.SEVERE));
        try {
            rs = this.changed.acceptChange(this.mode);
            SerializableChanger<?, ?> c = Classes.getSuperClassInfo(this.changed.getReturnType()).getChanger();
            what = c == null || !Arrays.equals(c.acceptChange(this.mode), rs) ? this.changed.toString(null, false) : Classes.getSuperClassInfo(this.changed.getReturnType()).getName().withIndefiniteArticle();
        }
        finally {
            h.stop();
        }
        if (rs == null) {
            if (h.getCount() > 0) {
                return false;
            }
            if (this.mode == Changer.ChangeMode.SET) {
                Skript.error(String.valueOf(what) + " can't be 'set' to anything", ErrorQuality.SEMANTIC_ERROR);
            } else if (this.mode == Changer.ChangeMode.DELETE) {
                Skript.error(String.valueOf(what) + " can't be cleared/deleted", ErrorQuality.SEMANTIC_ERROR);
            } else {
                Skript.error(String.valueOf(what) + " can't have anything " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " it", ErrorQuality.SEMANTIC_ERROR);
            }
            return false;
        }
        if (this.changer != null) {
            Object r;
            RetainingLogHandler log;
            Object x;
            Expression<Object> v;
            ErrorQuality q;
            block38: {
                q = this.changer.getReturnType() == Object.class ? ErrorQuality.NOT_AN_EXPRESSION : ErrorQuality.SEMANTIC_ERROR;
                v = null;
                x = null;
                log = SkriptLogger.startRetainingLog();
                try {
                    Object[] objectArray = rs;
                    int n = rs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        r = objectArray[n2];
                        if (((Class)(((Class)r).isArray() ? ((Class)r).getComponentType() : r)).isAssignableFrom(this.changer.getReturnType())) {
                            v = this.changer.getConvertedExpression(Object.class);
                            x = r;
                        }
                        ++n2;
                    }
                    if (v != null) break block38;
                    objectArray = rs;
                    n = rs.length;
                    n2 = 0;
                    while (n2 < n) {
                        r = objectArray[n2];
                        v = this.changer.getConvertedExpression(((Class)r).isArray() ? ((Class)r).getComponentType() : r);
                        if (v != null) {
                            x = r;
                            break;
                        }
                        ++n2;
                    }
                }
                finally {
                    log.stop();
                }
            }
            if (v == null) {
                if (log.hasErrors()) {
                    SkriptLogger.log(log.getFirstError());
                    return false;
                }
                r = new Class[rs.length];
                int i = 0;
                while (i < rs.length) {
                    r[i] = ((Class)rs[i]).isArray() ? ((Class)rs[i]).getComponentType() : rs[i];
                    ++i;
                }
                if (rs.length == 1 && rs[0] == Object.class) {
                    Skript.error("Can't understand this expression: " + this.changer, ErrorQuality.NOT_AN_EXPRESSION);
                } else if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(String.valueOf(what) + " can't be set to " + this.changer + " because the latter is " + SkriptParser.notOfType(r), q);
                } else {
                    Skript.error(String.valueOf(what) + " can't be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + this.changed + " because the former is " + SkriptParser.notOfType(r), q);
                }
                return false;
            }
            if (((Class)x).isArray()) {
                this.single = false;
                x = ((Class)x).getComponentType();
            }
            this.changer = v;
            if (!this.changer.isSingle() && this.single) {
                if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(this.changed + " can only be set to one " + Classes.getSuperClassInfo(x).getName() + ", not more", ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error("only one " + Classes.getSuperClassInfo(x).getName() + " can be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + this.changed + ", not more", ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        ?[] delta;
        ?[] objArray = this.changer == null ? null : (delta = this.single ? (?[])this.changer.getSingle(e) : this.changer.getArray(e));
        if (delta == null && this.mode != Changer.ChangeMode.DELETE) {
            return;
        }
        this.changed.change(e, delta, this.mode);
    }

    @Override
    public String toString(Event e, boolean debug) {
        switch (this.mode) {
            case ADD: {
                return "add " + this.changer.toString(e, debug) + " to " + this.changed.toString(null, true);
            }
            case DELETE: {
                return "delete " + this.changed.toString(null, true);
            }
            case REMOVE: {
                return "remove " + this.changer.toString(e, debug) + " from " + this.changed.toString(null, true);
            }
            case SET: {
                return "set " + this.changed.toString(e, debug) + " to " + this.changer.toString(null, true);
            }
        }
        throw new IllegalStateException();
    }
}

