/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Broadcast")
@Description(value={"Broadcasts a message to the server."})
@Examples(value={"broadcast \"Welcome %player% to the server!\"", "broadcast \"Woah! It's a message!\""})
@Since(value="1.0")
public class EffBroadcast
extends Effect {
    private Expression<String> messages;
    private Expression<World> worlds;

    static {
        Skript.registerEffect(EffBroadcast.class, "broadcast %strings% [(to|in) %-worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.messages = vars[0];
        this.worlds = vars[1];
        return true;
    }

    @Override
    public void execute(Event e) {
        String[] stringArray = this.messages.getArray(e);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            if (this.worlds == null) {
                Bukkit.broadcastMessage((String)m);
            } else {
                World[] worldArray = this.worlds.getArray(e);
                int n3 = worldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    World w = worldArray[n4];
                    for (Player p : w.getPlayers()) {
                        p.sendMessage(m);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "broadcast " + this.messages.toString(e, debug) + (this.worlds == null ? "" : " to " + this.worlds.toString(e, debug));
    }
}

