/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Setter;

public class Option<T> {
    public final String name;
    private boolean optional = false;
    private String value = null;
    private final Converter<String, ? extends T> parser;
    private T defaultValue = null;
    private T parsedValue = null;
    private Setter<? super T> setter;

    public Option(String name, Class<T> c) {
        this.name = name;
        if (c == String.class) {
            this.parser = new Converter<String, T>(){

                @Override
                public T convert(String s) {
                    return s;
                }
            };
        } else {
            final ClassInfo<T> ci = Classes.getExactClassInfo(c);
            if (ci == null || ci.getParser() == null) {
                throw new IllegalArgumentException();
            }
            this.parser = new Converter<String, T>(){

                @Override
                public T convert(String s) {
                    Object t = ci.getParser().parse(s, ParseContext.CONFIG);
                    if (t != null) {
                        return t;
                    }
                    Skript.error("'" + s + "' is not " + ci.getName().withIndefiniteArticle());
                    return null;
                }
            };
        }
    }

    public Option(String name, Converter<String, ? extends T> parser) {
        if (parser == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.parser = parser;
    }

    public final Option<T> setter(Setter<? super T> setter) {
        this.setter = setter;
        return this;
    }

    public final Option<T> optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public final Option<T> defaultValue(T def) {
        this.defaultValue = def;
        this.parsedValue = def;
        return this;
    }

    public final void set(Config config, String path) {
        String oldValue = this.value;
        this.value = config.getByPath(String.valueOf(path) + this.name);
        if (this.value == null && !this.optional) {
            Skript.error("Required entry '" + path + this.name + "' is missing in " + config.getFileName() + ". Please make sure that you have the latest version of the config.");
        }
        if (this.value == null ^ oldValue == null || this.value != null && !this.value.equals(oldValue)) {
            T t = this.parsedValue = this.value == null ? this.defaultValue : this.parser.convert(this.value);
            if (this.parsedValue == null) {
                this.parsedValue = this.defaultValue;
            }
            this.onValueChange();
        }
    }

    protected void onValueChange() {
        if (this.setter != null) {
            this.setter.set(this.parsedValue);
        }
    }

    public final T value() {
        return this.parsedValue;
    }

    public final boolean isOptional() {
        return this.optional;
    }
}

