/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Is Wearing")
@Description(value={"Checks whether a player is wearing some armour."})
@Examples(value={"player is wearing an iron chestplate and iron leggings", "player is wearing all diamond armour"})
@Since(value="1.0")
public class CondIsWearing
extends Condition {
    private Expression<Player> players;
    private Expression<ItemType> types;

    static {
        Skript.registerCondition(CondIsWearing.class, "%players% (is|are) wearing %itemtypes%", "%players% (isn't|is not|aren't|are not) wearing %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = vars[0];
        this.types = vars[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.players.toString(e, debug)) + (this.players.isSingle() ? " is" : " are") + (this.isNegated() ? "not " : "") + " wearing " + this.types;
    }

    @Override
    public boolean check(final Event e) {
        return this.players.check(e, new Checker<Player>(){

            @Override
            public boolean check(final Player p) {
                return CondIsWearing.this.types.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType t) {
                        ItemStack[] itemStackArray = p.getInventory().getArmorContents();
                        int n = itemStackArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ItemStack is = itemStackArray[n2];
                            if (t.isOfType(is) ^ t.isAll()) {
                                return !t.isAll();
                            }
                            ++n2;
                        }
                        return t.isAll();
                    }
                }, CondIsWearing.this.isNegated());
            }
        });
    }
}

