/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

@Name(value="Exists/Is Set")
@Description(value={"Checks whether a given expression or variable is set."})
@Examples(value={"{teamscript.%player%.preferred team} is not set", "on damage:", "\tprojectile exists", "\tbroadcast \"%attacker% used a projectile to attack %victim%!\""})
@Since(value="1.2")
public class CondIsSet
extends Condition {
    private Expression<?> expr;

    static {
        Skript.registerCondition(CondIsSet.class, "%objects% (exists|is set)", "%objects% (doesn't exist|does not exist|isn't set|is not set)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = exprs[0];
        if (this.expr instanceof Literal) {
            return false;
        }
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.expr.toString(e, debug)) + (this.isNegated() ? " isn't" : " is") + " set";
    }

    @Override
    public boolean check(Event e) {
        return this.isNegated() ^ this.expr.getArray(e).length > 0;
    }
}

