/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.WeakHashMap;
import org.bukkit.event.Event;

public class Argument<T>
implements Serializable {
    private final Expression<? extends T> def;
    private final Class<T> type;
    private final boolean single;
    private final int index;
    private final boolean optional;
    private transient WeakHashMap<Event, T[]> current = new WeakHashMap();

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.current = new WeakHashMap();
    }

    public Argument(Expression<? extends T> def, Class<T> type, boolean single, int index, boolean optional) {
        this.def = def;
        this.type = type;
        this.single = single;
        this.index = index;
        this.optional = optional;
    }

    public static <T> Argument<T> newInstance(Class<T> type, String def, int index, boolean single, boolean forceOptional) {
        Expression<T> d = null;
        if (def != null) {
            if (def.startsWith("%") && def.endsWith("%")) {
                RetainingLogHandler log = SkriptLogger.startRetainingLog();
                try {
                    d = SkriptParser.parseExpression(def.substring(1, def.length() - 1), 1, ParseContext.COMMAND, type);
                    if (d == null) {
                        log.printErrors("Can't understand this expression: " + def);
                        return null;
                    }
                }
                finally {
                    log.stop();
                }
                log.printLog();
            } else {
                RetainingLogHandler log = SkriptLogger.startRetainingLog();
                try {
                    d = type == String.class && def.startsWith("\"") && def.endsWith("\"") ? VariableString.newInstance(def.substring(1, def.length() - 1)) : SkriptParser.parseLiteral(def, type, ParseContext.DEFAULT);
                }
                finally {
                    log.stop();
                }
                if (d == null) {
                    log.printErrors("'" + def + "' is not " + Classes.getSuperClassInfo(type).getName().withIndefiniteArticle());
                    return null;
                }
            }
        }
        return new Argument<T>(d, type, single, index, def != null || forceOptional);
    }

    public String toString() {
        return "<" + Utils.toEnglishPlural(Classes.getExactClassName(this.type), !this.single) + (this.def == null ? "" : " = " + this.def.toString()) + ">";
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setToDefault(ScriptCommandEvent event) {
        if (this.def != null) {
            this.current.put(event, this.def.getArray(event));
        }
    }

    public void set(ScriptCommandEvent e, Object[] o) {
        if (o == null || !this.type.isAssignableFrom(o.getClass().getComponentType())) {
            throw new IllegalArgumentException();
        }
        this.current.put(e, o);
    }

    public T[] getCurrent(Event e) {
        return this.current.get(e);
    }

    public Class<T> getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSingle() {
        return this.single;
    }
}

