/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.IntegerArithmetic;
import ch.njol.skript.classes.NumberArithmetic;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;

public class DefaultClasses {
    public static final int VARIABLENAME_NUMBERACCURACY = 8;

    static {
        Classes.registerClass(new ClassInfo<Object>(Object.class, "object").name("Object").description("The supertype of all types, meaning that if %object% is used in e.g. a condition it will accept all kinds of expressions.").usage("").examples("").since("1.0"));
        Classes.registerClass(new ClassInfo<Number>(Number.class, "number").user("num(ber)?s?").name("Number").description("A number, e.g. 2.5, 3, or -9812454.", "Please note that many expressions only need integers, i.e. will discard any frational parts of any numbers without producing an error.").usage("<code>[-]###[.###]</code> (any amount of digits, very big numbers will be truncated though)").examples("set the player's health to 5.5", "set {_temp} to 2*{_temp} - 2.5").since("1.0").parser(new Parser<Number>(){

            @Override
            public Number parse(String s, ParseContext context) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return s.endsWith("%") ? Double.parseDouble(s.substring(0, s.length() - 1)) / 100.0 : Double.valueOf(s);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            }

            @Override
            public String toString(Number n) {
                return StringUtils.toString(n.doubleValue(), SkriptConfig.numberAccuracy.value());
            }

            @Override
            public String toVariableNameString(Number n) {
                return StringUtils.toString(n.doubleValue(), 8);
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+(\\.\\d+)?";
            }
        }).serializer(new Serializer<Number>(){

            @Override
            public String serialize(Number n) {
                return "" + n;
            }

            @Override
            public Number deserialize(String s) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Double.valueOf(s);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            }
        }));
        Classes.registerClass(new ClassInfo<Long>(Long.class, "long").user("int(eger)?s?").before("integer", "short", "byte").defaultExpression(new SimpleLiteral<Long>(1L, true)).parser(new Parser<Long>(){

            @Override
            public Long parse(String s, ParseContext context) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Long l) {
                return "" + l;
            }

            @Override
            public String toVariableNameString(Long l) {
                return "" + l;
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+";
            }
        }).serializer(new Serializer<Long>(){

            @Override
            public String serialize(Long l) {
                return "" + l;
            }

            @Override
            public Long deserialize(String s) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Double.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<Integer>(Integer.class, "integer").defaultExpression(new SimpleLiteral<Integer>(1, true)).parser(new Parser<Integer>(){

            @Override
            public Integer parse(String s, ParseContext context) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Integer i) {
                return "" + i;
            }

            @Override
            public String toVariableNameString(Integer i) {
                return "" + i;
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+";
            }
        }).serializer(new Serializer<Integer>(){

            @Override
            public String serialize(Integer i) {
                return "" + i;
            }

            @Override
            public Integer deserialize(String s) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Integer.class, new IntegerArithmetic()));
        Classes.registerClass(new ClassInfo<Double>(Double.class, "double").defaultExpression(new SimpleLiteral<Double>(1.0, true)).after("long").before("float", "integer", "short", "byte").parser(new Parser<Double>(){

            @Override
            public Double parse(String s, ParseContext context) {
                try {
                    return s.endsWith("%") ? Double.parseDouble(s.substring(0, s.length() - 1)) / 100.0 : Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Double d) {
                return StringUtils.toString(d, SkriptConfig.numberAccuracy.value());
            }

            @Override
            public String toVariableNameString(Double d) {
                return StringUtils.toString(d, 8);
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+(\\.\\d+)?";
            }
        }).serializer(new Serializer<Double>(){

            @Override
            public String serialize(Double d) {
                return "" + d;
            }

            @Override
            public Double deserialize(String s) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Double.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<Float>(Float.class, "float").defaultExpression(new SimpleLiteral<Float>(Float.valueOf(1.0f), true)).parser(new Parser<Float>(){

            @Override
            public Float parse(String s, ParseContext context) {
                try {
                    return Float.valueOf(s.endsWith("%") ? Float.parseFloat(s.substring(0, s.length() - 1)) / 100.0f : Float.valueOf(s).floatValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Float f) {
                return StringUtils.toString(f.floatValue(), SkriptConfig.numberAccuracy.value());
            }

            @Override
            public String toVariableNameString(Float f) {
                return StringUtils.toString(f.doubleValue(), 8);
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+(\\.\\d+)?";
            }
        }).serializer(new Serializer<Float>(){

            @Override
            public String serialize(Float f) {
                return "" + f;
            }

            @Override
            public Float deserialize(String s) {
                try {
                    return Float.valueOf(Float.parseFloat(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Double.class, new NumberArithmetic()));
        Classes.registerClass(new ClassInfo<Boolean>(Boolean.class, "boolean").user("booleans?").name("Boolean").description("A boolean is a value that is either true or false. Other accepted names are 'on' and 'yes' for true, and 'off' and 'no' for false.").usage("true/yes/on or false/no/off").examples("set {config.%player%.use mod} to false").since("1.0").parser(new Parser<Boolean>(){

            @Override
            public Boolean parse(String s, ParseContext context) {
                if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("on")) {
                    return Boolean.TRUE;
                }
                if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("off")) {
                    return Boolean.FALSE;
                }
                return null;
            }

            @Override
            public String toString(Boolean b) {
                return b.toString();
            }

            @Override
            public String toVariableNameString(Boolean b) {
                return "" + b;
            }

            @Override
            public String getVariableNamePattern() {
                return "(true|false)";
            }
        }).serializer(new Serializer<Boolean>(){

            @Override
            public String serialize(Boolean b) {
                return "" + b;
            }

            @Override
            public Boolean deserialize(String s) {
                if (s.equals("true")) {
                    return Boolean.TRUE;
                }
                if (s.equals("false")) {
                    return Boolean.FALSE;
                }
                return null;
            }
        }));
        Classes.registerClass(new ClassInfo<Short>(Short.class, "short").defaultExpression(new SimpleLiteral<Short>((short)1, true)).parser(new Parser<Short>(){

            @Override
            public Short parse(String s, ParseContext context) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Short s) {
                return "" + s;
            }

            @Override
            public String toVariableNameString(Short s) {
                return "" + s;
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+";
            }
        }).serializer(new Serializer<Short>(){

            @Override
            public String serialize(Short s) {
                return "" + s;
            }

            @Override
            public Short deserialize(String s) {
                try {
                    return Short.parseShort(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Integer.class, new IntegerArithmetic()));
        Classes.registerClass(new ClassInfo<Byte>(Byte.class, "byte").defaultExpression(new SimpleLiteral<Byte>((byte)1, true)).parser(new Parser<Byte>(){

            @Override
            public Byte parse(String s, ParseContext context) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            @Override
            public String toString(Byte b) {
                return "" + b;
            }

            @Override
            public String toVariableNameString(Byte b) {
                return "" + b;
            }

            @Override
            public String getVariableNamePattern() {
                return "-?\\d+";
            }
        }).serializer(new Serializer<Byte>(){

            @Override
            public String serialize(Byte b) {
                return "" + b;
            }

            @Override
            public Byte deserialize(String s) {
                try {
                    return Byte.parseByte(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }).math(Integer.class, new IntegerArithmetic()));
        Classes.registerClass(new ClassInfo<String>(String.class, "string").user("texts?").name("Text").description("Text is simply text, i.e. a sequence of characters, which can optionally contain expressions which will be replaced with a meaningful representation (e.g. %player% will be replaced with the player's name).", "Because scripts are also text, you have to put text into double quotes to tell Skript which part of the line is an effect/expression and which part is the text.", "Please read the article on <a href='../strings'>Texts and Variable Names</a> to learn more.").usage("simple: <code>\"...\"</code>", "quotes: <code>\"...\"\"...\"</code>", "expressions: <code>\"...%expression%...\"</code>", "percent signs: <code>\"...%%...\"</code>").examples("broadcast \"Hello World!\"", "message \"Hello %player%\"", "message \"The id of \"\"%type of tool%\"\" is %id of tool%.\"").since("1.0").parser(new Parser<String>(){

            @Override
            public String parse(String s, ParseContext context) {
                switch (context) {
                    case DEFAULT: {
                        throw new SkriptAPIException("Strings must not be parsed as DEFAULT using it's Parser, but by parsing it as a VariableString!");
                    }
                    case COMMAND: {
                        return s;
                    }
                    case CONFIG: {
                        if (!VariableString.isQuotedCorrectly(s, true)) {
                            return null;
                        }
                        return Utils.replaceChatStyles(s.substring(1, s.length() - 1).replace("\"\"", "\""));
                    }
                    case EVENT: {
                        if (VariableString.isQuotedCorrectly(s, true)) {
                            return Utils.replaceChatStyles(s.substring(1, s.length() - 1).replace("\"\"", "\""));
                        }
                        return Utils.replaceChatStyles(s);
                    }
                }
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return context != ParseContext.DEFAULT;
            }

            @Override
            public String toString(String s) {
                return s;
            }

            @Override
            public String getDebugMessage(String s) {
                return String.valueOf('\"') + s + '\"';
            }

            @Override
            public String toVariableNameString(String o) {
                return o;
            }

            @Override
            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer(new Serializer<String>(){

            @Override
            public String serialize(String s) {
                return s;
            }

            @Override
            public String deserialize(String s) {
                return s;
            }
        }));
    }
}

