/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumParser;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.classes.data.DefaultChangers;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.PotionEffectUtils;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Task;
import ch.njol.util.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class BukkitClasses {
    static {
        Classes.registerClass(new ClassInfo<Entity>(Entity.class, "entity").user("entit(y|ies)").name("Entity").description("An entity is something in a <a href='#world'>world</a> that's not a <a href='#block'>block</a>, e.g. a <a href='#player'>player</a>, a skeleton, or a zombie, but also <a href='#projectile'>projectiles</a> like arrows, fireballs or thrown potions, or special entities like dropped items, falling blocks or paintings.").usage("player, op, wolf, tamed ocelot, powered creeper, zombie, unsaddled pig, fireball, arrow, dropped item, item frame, etc.").examples("entity is a zombie or creeper", "player is an op", "projectile is an arrow", "shoot a fireball from the player").since("1.0").defaultExpression(new EventValueExpression<Entity>(Entity.class)).parser(new Parser<Entity>(){

            @Override
            public Entity parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toVariableNameString(Entity e) {
                return "entity:" + e.getUniqueId().toString().toLowerCase(Locale.ENGLISH);
            }

            @Override
            public String getVariableNamePattern() {
                return "entity:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
            }

            @Override
            public String toString(Entity e) {
                return EntityData.toString(e);
            }
        }).changer(DefaultChangers.entityChanger));
        Classes.registerClass(new ClassInfo<LivingEntity>(LivingEntity.class, "livingentity").user("living ?entit(y|ies)").name("Living Entity").description("A living <a href='#entity'>entity</a>, i.e. a mob or <a href='#player'>player</a>, not inanimate entities like <a href='#projectile'>projectiles</a> or dropped items.").usage("see <a href='#entity'>entity</a>, but ignore inanimate objects").examples("spawn 5 powered creepers", "shoot a zombie from the creeper").since("1.0").defaultExpression(new EventValueExpression<LivingEntity>(LivingEntity.class)).changer(DefaultChangers.entityChanger));
        Classes.registerClass(new ClassInfo<Projectile>(Projectile.class, "projectile").user("projectiles?").name("Projectile").description("A projectile, e.g. an arrow, snowball or thrown potion.").usage("arrow, fireball, snowball, thrown potion, etc.").examples("projectile is a snowball", "shoot an arrow at speed 5 from the player").since("1.0").defaultExpression(new EventValueExpression<Projectile>(Projectile.class)).changer(DefaultChangers.nonLivingEntityChanger));
        Classes.registerClass(new ClassInfo<Block>(Block.class, "block").user("blocks?").name("Block").description("A block in a <a href='#world'>world</a>. It has a <a href='#location'>location</a> and a <a href='#itemstack'>type</a>, and can also have a <a href='#direction'>direction</a> (mostly a <a href='../expressions/#ExprFacing'>facing</a>), an <a href='#inventory'>inventory</a>, or other special properties.").usage("").examples("").since("1.0").defaultExpression(new EventValueExpression<Block>(Block.class)).parser(new Parser<Block>(){

            @Override
            public Block parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Block b) {
                return ItemType.toString(new ItemStack(b.getTypeId(), 1, (short)b.getState().getRawData()));
            }

            @Override
            public String toVariableNameString(Block b) {
                return String.valueOf(b.getWorld().getName()) + ":" + b.getX() + "," + b.getY() + "," + b.getZ();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S:-?\\d+,-?\\d+,-?\\d+";
            }

            @Override
            public String getDebugMessage(Block b) {
                return String.valueOf(this.toString(b)) + " block (" + b.getWorld().getName() + ":" + b.getX() + "," + b.getY() + "," + b.getZ() + ")";
            }
        }).changer(DefaultChangers.blockChanger).serializer(new Serializer<Block>(){

            @Override
            public String serialize(Block b) {
                return String.valueOf(b.getWorld().getName()) + ":" + b.getX() + "," + b.getY() + "," + b.getZ();
            }

            @Override
            public Block deserialize(String s) {
                final String[] split = s.split("[:,]");
                if (split.length != 4) {
                    return null;
                }
                return Task.callSync(new Callable<Block>(){

                    @Override
                    public Block call() throws Exception {
                        World w = Bukkit.getWorld((String)split[0]);
                        if (w == null) {
                            return null;
                        }
                        try {
                            int[] l = new int[3];
                            int i = 0;
                            while (i < 3) {
                                l[i] = Integer.parseInt(split[i + 1]);
                                ++i;
                            }
                            return w.getBlockAt(l[0], l[1], l[2]);
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }
                });
            }
        }));
        Classes.registerClass(new ClassInfo<Location>(Location.class, "location").user("locations?").name("Location").description("A location in a <a href='#world'>world</a>. Locations are world-specific and even store a <a href='#direction'>direction</a>, e.g. if you save a location and later teleport to it you will face the exact same direction you did when you saved the location.").usage("").examples("").since("1.0").defaultExpression(new EventValueExpression<Location>(Location.class)).parser(new Parser<Location>(){

            @Override
            public Location parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Location l) {
                return "x: " + Skript.toString(l.getX()) + ", y: " + Skript.toString(l.getY()) + ", z: " + Skript.toString(l.getZ());
            }

            @Override
            public String toVariableNameString(Location l) {
                return String.valueOf(l.getWorld().getName()) + ":" + l.getX() + "," + l.getY() + "," + l.getZ();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S:-?\\d+(\\.\\d+)?,-?\\d+(\\.\\d+)?,-?\\d+(\\.\\d+)?";
            }

            @Override
            public String getDebugMessage(Location l) {
                return "(" + l.getWorld().getName() + ":" + l.getX() + "," + l.getY() + "," + l.getZ() + "|yaw=" + l.getYaw() + "/pitch=" + l.getPitch() + ")";
            }
        }).serializer(new Serializer<Location>(){

            @Override
            public String serialize(Location l) {
                return String.valueOf(l.getWorld().getName()) + ":" + l.getX() + "," + l.getY() + "," + l.getZ() + "|" + l.getYaw() + "/" + l.getPitch();
            }

            @Override
            public Location deserialize(String s) {
                final String[] split = s.split("[:,|/]");
                if (split.length != 6) {
                    return null;
                }
                return Task.callSync(new Callable<Location>(){

                    @Override
                    public Location call() throws Exception {
                        World w = Bukkit.getWorld((String)split[0]);
                        if (w == null) {
                            return null;
                        }
                        try {
                            double[] l = new double[5];
                            int i = 0;
                            while (i < 5) {
                                l[i] = Double.parseDouble(split[i + 1]);
                                ++i;
                            }
                            return new Location(w, l[0], l[1], l[2], (float)l[3], (float)l[4]);
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }
                });
            }
        }));
        Classes.registerClass(new ClassInfo<World>(World.class, "world").user("worlds?").name("World").description("One of the server's worlds. Worlds can be put into scripts by surrounding their name with double quotes, e.g. \"world_nether\", but this might not work reliably as <a href='#string'>text</a> uses the same syntax.").usage("<code>\"world_name\"</code>, e.g. \"world\"").examples("broadcast \"Hello!\" to \"world_nether\"").since("1.0").after("string").defaultExpression(new EventValueExpression<World>(World.class)).parser(new Parser<World>(){

            @Override
            public World parse(String s, ParseContext context) {
                if (context == ParseContext.COMMAND) {
                    return Bukkit.getWorld((String)s);
                }
                if (s.matches("\".+\"")) {
                    return Bukkit.getWorld((String)s.substring(1, s.length() - 1));
                }
                return null;
            }

            @Override
            public String toString(World w) {
                return w.getName();
            }

            @Override
            public String toVariableNameString(World o) {
                return o.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }).serializer(new Serializer<World>(){

            @Override
            public String serialize(World w) {
                return w.getName();
            }

            @Override
            public World deserialize(final String s) {
                return Task.callSync(new Callable<World>(){

                    @Override
                    public World call() throws Exception {
                        return Bukkit.getWorld((String)s);
                    }
                });
            }
        }));
        Classes.registerClass(new ClassInfo<Inventory>(Inventory.class, "inventory").user("inventor(y|ies)").name("Inventory").description("An inventory of a <a href='#player'>player</a> or <a href='#block'>block</a>. Inventories have many effects and conditions regarding the items contained.", "An inventory has a fixed amount of <a href='#slot'>slots</a> which represent a specific place in the inventory, e.g. the <a href='../expressions/#ExprArmorSlot'>helmet slot</a> for players (Please note that slot support is still very limited but will be improved eventually).").usage("").examples("").since("1.0").defaultExpression(new EventValueExpression<Inventory>(Inventory.class)).parser(new Parser<Inventory>(){

            @Override
            public Inventory parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Inventory i) {
                return "inventory of " + Classes.toString(i.getHolder());
            }

            @Override
            public String getDebugMessage(Inventory i) {
                return "inventory of " + Classes.getDebugMessage(i.getHolder());
            }

            @Override
            public String toVariableNameString(Inventory o) {
                return "inventory of " + Classes.toString(o.getHolder(), StringMode.VARIABLE_NAME, false);
            }

            @Override
            public String getVariableNamePattern() {
                return "inventory of .+";
            }
        }).changer(DefaultChangers.inventoryChanger));
        Classes.registerClass(new ClassInfo<Player>(Player.class, "player").user("players?").name("Player").description("A player. Depending on whether a player is online or offline several actions can be performed with them, though you won't get any errors when using effects that only work if the player is online (e.g. changing his inventory) on an offline player.", "You have two possibilities to use players as command arguments: &lt;player&gt; and &lt;offline player&gt;. The first requires that the player is online and also accepts only part of the name, while the latter doesn't require that the player is online, but the player's name has to be entered exactly.").usage("").examples("").since("1.0").defaultExpression(new EventValueExpression<Player>(Player.class)).after("string").parser(new Parser<Player>(){

            @Override
            public Player parse(String s, ParseContext context) {
                if (context == ParseContext.COMMAND) {
                    List ps = Bukkit.matchPlayer((String)s);
                    if (ps.size() == 1) {
                        return (Player)ps.get(0);
                    }
                    if (ps.size() == 0) {
                        Skript.error("There is no player online whose name starts with '" + s + "'");
                    } else {
                        Skript.error("There are several players online whose names start with '" + s + "'");
                    }
                    return null;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return context == ParseContext.COMMAND;
            }

            @Override
            public String toString(Player p) {
                return String.valueOf(p.getDisplayName()) + ChatColor.RESET;
            }

            @Override
            public String toCommandString(Player p) {
                return p.getName();
            }

            @Override
            public String toVariableNameString(Player p) {
                return p.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }

            @Override
            public String getDebugMessage(Player p) {
                return String.valueOf(p.getName()) + " " + Classes.getDebugMessage(p.getLocation());
            }
        }).changer(DefaultChangers.playerChanger).serializeAs(OfflinePlayer.class));
        Classes.registerClass(new ClassInfo<OfflinePlayer>(OfflinePlayer.class, "offlineplayer").user("offline ?players?").name("Offlineplayer").description("A player that is possibly offline. See <a href='#player'>player</a> for more information.").usage("").examples("").since("").defaultExpression(new EventValueExpression<OfflinePlayer>(OfflinePlayer.class)).after("string").parser(new Parser<OfflinePlayer>(){

            @Override
            public OfflinePlayer parse(String s, ParseContext context) {
                if (context == ParseContext.COMMAND) {
                    if (!s.matches("\\S+")) {
                        return null;
                    }
                    return Bukkit.getOfflinePlayer((String)s);
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return context == ParseContext.COMMAND;
            }

            @Override
            public String toString(OfflinePlayer p) {
                if (p.isOnline()) {
                    return String.valueOf(p.getPlayer().getDisplayName()) + ChatColor.RESET;
                }
                return p.getName();
            }

            @Override
            public String toCommandString(OfflinePlayer p) {
                return p.getName();
            }

            @Override
            public String toVariableNameString(OfflinePlayer p) {
                return p.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }

            @Override
            public String getDebugMessage(OfflinePlayer p) {
                if (p.isOnline()) {
                    return Classes.getDebugMessage(p.getPlayer());
                }
                return p.getName();
            }
        }).serializer(new Serializer<OfflinePlayer>(){

            @Override
            public String serialize(OfflinePlayer p) {
                return p.getName();
            }

            @Override
            public OfflinePlayer deserialize(final String s) {
                return Task.callSync(new Callable<OfflinePlayer>(){

                    @Override
                    public OfflinePlayer call() throws Exception {
                        return Bukkit.getOfflinePlayer((String)s);
                    }
                });
            }
        }));
        Classes.registerClass(new ClassInfo<CommandSender>(CommandSender.class, "commandsender").defaultExpression(new EventValueExpression<CommandSender>(CommandSender.class)).parser(new Parser<CommandSender>(){

            @Override
            public CommandSender parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(CommandSender s) {
                return s.getName();
            }

            @Override
            public String toVariableNameString(CommandSender o) {
                return o.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return "\\S+";
            }
        }));
        Classes.registerClass(new ClassInfo<InventoryHolder>(InventoryHolder.class, "inventoryholder").defaultExpression(new EventValueExpression<InventoryHolder>(InventoryHolder.class)));
        Classes.registerClass(new ClassInfo<GameMode>(GameMode.class, "gamemode").user("game ?modes?").name("Game Mode").description("The game modes survival, creative and adventure.").usage("creative/survival/adventure").examples("player's gamemode is survival", "set the player argument's game mode to creative").since("1.0").defaultExpression(new SimpleLiteral<GameMode>(GameMode.SURVIVAL, true)).parser(new Parser<GameMode>(){

            @Override
            public GameMode parse(String s, ParseContext context) {
                try {
                    return GameMode.valueOf((String)s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }

            @Override
            public String toString(GameMode m) {
                return m.toString().toLowerCase();
            }

            @Override
            public String toVariableNameString(GameMode o) {
                return o.toString().toLowerCase(Locale.ENGLISH);
            }

            @Override
            public String getVariableNamePattern() {
                return "[a-z]+";
            }
        }).serializer(new EnumSerializer<GameMode>(GameMode.class)));
        Classes.registerClass(new ClassInfo<ItemStack>(ItemStack.class, "itemstack").user("item", "material").name("Item / Material").description("An item, e.g. a stack of torches, a furnace, or a wooden sword of sharpness 2. Unlike <a href='#itemtype'>item type</a> an item can only represent exactly one item (e.g. an upside-down cobblestone stair facing west), while an item type can represent a whole range of items (e.g. any cobble stone stairs regardless of direction).", "You don't usually need this type except when you want to make a command that only accepts an exact item.", "Please note that currently 'material' is exactly the same as 'item', i.e. can have an amount & enchantments.").usage("<code>[&lt;number&gt; [of]] &lt;alias&gt; [of &lt;enchantment&gt; &lt;level&gt;]</code>, Where &lt;alias&gt; must be an alias that represents exactly one item (i.e cannot be a general alias like 'sword' or 'plant')").examples("set {_item} to type of the targeted block", "{_item} is a torch").since("1.0").after("number").parser(new Parser<ItemStack>(){

            @Override
            public ItemStack parse(String s, ParseContext context) {
                ItemType t = Aliases.parseItemType(s);
                if (t == null) {
                    return null;
                }
                if ((t = t.getItem()).numTypes() != 1) {
                    Skript.error("'" + s + "' represents multiple materials");
                    return null;
                }
                if (!t.getTypes().get(0).hasDataRange()) {
                    return t.getRandom();
                }
                if (t.getTypes().get((int)0).dataMin > 0) {
                    Skript.error("'" + s + "' represents multiple materials");
                    return null;
                }
                ItemStack i = t.getRandom();
                i.setDurability((short)0);
                return i;
            }

            @Override
            public String toString(ItemStack i) {
                return ItemType.toString(i);
            }

            @Override
            public String toVariableNameString(ItemStack i) {
                StringBuilder b = new StringBuilder("item:");
                b.append(i.getType().name());
                b.append(":" + i.getDurability());
                b.append("*" + i.getAmount());
                for (Map.Entry e : i.getEnchantments().entrySet()) {
                    b.append("#" + ((Enchantment)e.getKey()).getId());
                    b.append(":" + e.getValue());
                }
                return b.toString();
            }

            @Override
            public String getVariableNamePattern() {
                return "item:.+";
            }
        }).serializer(new Serializer<ItemStack>(){

            @Override
            public String serialize(ItemStack i) {
                StringBuilder b = new StringBuilder();
                b.append(i.getTypeId());
                b.append(":" + i.getDurability());
                b.append("*" + i.getAmount());
                for (Map.Entry e : i.getEnchantments().entrySet()) {
                    b.append("#" + ((Enchantment)e.getKey()).getId());
                    b.append(":" + e.getValue());
                }
                return b.toString();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ItemStack deserialize(String s) {
                String[] split = s.split("[:*#]");
                if (split.length < 3 || split.length % 2 != 1) {
                    return null;
                }
                int typeId = -1;
                try {
                    typeId = Material.valueOf((String)split[0]).getId();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    ItemStack is = new ItemStack(typeId == -1 ? Integer.parseInt(split[0]) : typeId, Integer.parseInt(split[2]), Short.parseShort(split[1]));
                    int i = 3;
                    while (true) {
                        if (i >= split.length) {
                            return is;
                        }
                        Enchantment ench = Enchantment.getById((int)Integer.parseInt(split[i]));
                        if (ench == null) {
                            return null;
                        }
                        is.addUnsafeEnchantment(ench, Integer.parseInt(split[i + 1]));
                        i += 2;
                    }
                }
                catch (NumberFormatException e) {
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }));
        Classes.registerClass(new ClassInfo<Biome>(Biome.class, "biome").user("biomes?").name("Biome").description("All possible biomes Minecraft uses to generate a world.").usage(ClassInfo.ENUM_USAGE).examples("biome at the player is desert").since("1.4.4").parser(new EnumParser<Biome>(Biome.class)).serializer(new EnumSerializer<Biome>(Biome.class)));
        Classes.registerClass(new ClassInfo<PotionEffectType>(PotionEffectType.class, "potioneffecttype").user("potions?( ?effects?)?( ?types?)?").name("Potion Effect Type").description("A potion effect, e.g. 'strength' or 'swiftness'.").usage(StringUtils.join(PotionEffectUtils.getNames(), ", ")).examples("apply swiftness 5 to the player", "remove invisibility from the victim").since("").parser(new Parser<PotionEffectType>(){

            @Override
            public PotionEffectType parse(String s, ParseContext context) {
                return PotionEffectUtils.parse(s);
            }

            @Override
            public String toString(PotionEffectType o) {
                return PotionEffectUtils.toString(o);
            }

            @Override
            public String toVariableNameString(PotionEffectType o) {
                return o.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer(new Serializer<PotionEffectType>(){

            @Override
            public String serialize(PotionEffectType o) {
                return o.getName();
            }

            @Override
            public PotionEffectType deserialize(String s) {
                return PotionEffectType.getByName((String)s);
            }
        }));
        Classes.registerClass(new ClassInfo<Chunk>(Chunk.class, "chunk").user("chunks?").name("Chunk").description("A chunk is a cuboid of 16x16x128 blocks. Chunks are spread on a fixed rectangular grid in their world.").usage("").examples("").since("2.0").parser(new Parser<Chunk>(){

            @Override
            public Chunk parse(String s, ParseContext context) {
                return null;
            }

            @Override
            public boolean canParse(ParseContext context) {
                return false;
            }

            @Override
            public String toString(Chunk c) {
                return "chunk (" + c.getX() + "," + c.getZ() + ") of " + c.getWorld().getName();
            }

            @Override
            public String toVariableNameString(Chunk c) {
                return String.valueOf(c.getWorld().getName()) + ":" + c.getX() + "," + c.getZ();
            }

            @Override
            public String getVariableNamePattern() {
                return ".+:-?[0-9]+,-?[0-9]+";
            }
        }).serializer(new Serializer<Chunk>(){

            @Override
            public String serialize(Chunk c) {
                return String.valueOf(c.getWorld().getName()) + ":" + c.getX() + "," + c.getZ();
            }

            @Override
            public Chunk deserialize(String s) {
                final String[] split = s.split("[:,]");
                if (split.length != 3) {
                    return null;
                }
                return Task.callSync(new Callable<Chunk>(){

                    @Override
                    public Chunk call() throws Exception {
                        World w = Bukkit.getWorld((String)split[0]);
                        if (w == null) {
                            return null;
                        }
                        try {
                            int x = Integer.parseInt(split[1]);
                            int z = Integer.parseInt(split[1]);
                            return w.getChunkAt(x, z);
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }
                });
            }
        }));
        Classes.registerClass(new ClassInfo<Enchantment>(Enchantment.class, "enchantment").user("enchantments?").name("Enchantment").description("An enchantment, e.g. 'sharpness' or 'furtune'. Unlike <a href='#enchantmenttype'>enchantment type</a> this type has no level, but you usually don't need to use this type anyways.").usage(StringUtils.join(EnchantmentType.getNames(), ", ")).examples("").since("1.4.6").before("enchantmenttype").parser(new Parser<Enchantment>(){

            @Override
            public Enchantment parse(String s, ParseContext context) {
                return EnchantmentType.parseEnchantment(s);
            }

            @Override
            public String toString(Enchantment e) {
                return EnchantmentType.toString(e);
            }

            @Override
            public String toVariableNameString(Enchantment e) {
                return e.getName();
            }

            @Override
            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer(new Serializer<Enchantment>(){

            @Override
            public String serialize(Enchantment e) {
                return "" + e.getId();
            }

            @Override
            public Enchantment deserialize(String s) {
                try {
                    return Enchantment.getById((int)Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
    }
}

