/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.localization.RegexMessage;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.Setter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;

public abstract class Aliases {
    private static final HashMap<String, ItemType> aliases = new HashMap(2500);
    private static final HashMap<Integer, MaterialName> materialNames = new HashMap(Material.values().length);
    private static String itemSingular = "item";
    private static String itemPlural = "items";
    private static String blockSingular = "block";
    private static String blockPlural = "blocks";
    private static final ItemType everything = new ItemType();
    private static final Message m_brackets_error;
    private static final ArgsMessage m_empty_alias;
    private static final ArgsMessage m_unknown_variation;
    private static final Message m_starting_with_number;
    private static final Message m_missing_aliases;
    private static final Message m_empty_string;
    private static final ArgsMessage m_invalid_item_data;
    private static final ArgsMessage m_invalid_id;
    private static final Message m_invalid_block_data;
    private static final ArgsMessage m_invalid_item_type;
    private static final ArgsMessage m_out_of_data_range;
    private static final Message m_invalid_range;
    private static final ArgsMessage m_invalid_section;
    private static final ArgsMessage m_section_not_found;
    private static final ArgsMessage m_not_a_section;
    private static final Message m_unexpected_non_variation_section;
    private static final Message m_unexpected_section;
    private static final ArgsMessage m_loaded_x_aliases_from;
    private static final ArgsMessage m_loaded_x_aliases;
    private static final RegexMessage p_any;
    private static final RegexMessage p_every;
    private static final RegexMessage p_of_every;
    private static final RegexMessage p_of;
    private static Config aliasConfig;

    static {
        everything.setAll(true);
        everything.add(new ItemData());
        m_brackets_error = new Message("aliases.brackets error");
        m_empty_alias = new ArgsMessage("aliases.empty alias");
        m_unknown_variation = new ArgsMessage("aliases.unknown variation");
        m_starting_with_number = new Message("aliases.starting with number");
        m_missing_aliases = new Message("aliases.missing aliases");
        m_empty_string = new Message("aliases.empty string");
        m_invalid_item_data = new ArgsMessage("aliases.invalid item data");
        m_invalid_id = new ArgsMessage("aliases.invalid id");
        m_invalid_block_data = new Message("aliases.invalid block data");
        m_invalid_item_type = new ArgsMessage("aliases.invalid item type");
        m_out_of_data_range = new ArgsMessage("aliases.out of data range");
        m_invalid_range = new Message("aliases.invalid range");
        m_invalid_section = new ArgsMessage("aliases.invalid section");
        m_section_not_found = new ArgsMessage("aliases.section not found");
        m_not_a_section = new ArgsMessage("aliases.not a section");
        m_unexpected_non_variation_section = new Message("aliases.unexpected non-variation section");
        m_unexpected_section = new Message("aliases.unexpected section");
        m_loaded_x_aliases_from = new ArgsMessage("aliases.loaded x aliases from");
        m_loaded_x_aliases = new ArgsMessage("aliases.loaded x aliases");
        p_any = new RegexMessage("aliases.any", "", " (.+)", 2);
        p_every = new RegexMessage("aliases.every", "", " (.+)", 2);
        p_of_every = new RegexMessage("aliases.of every", "(\\d+) ", " (.+)", 2);
        p_of = new RegexMessage("aliases.of", "(\\d+) (?:", " )?(.+)", 2);
    }

    private static final ItemType getAlias_i(String s) {
        ItemType t = ScriptLoader.currentAliases.get(s);
        if (t != null) {
            return t;
        }
        return aliases.get(s);
    }

    private static HashMap<String, ItemType> getAliases(String name, ItemType value, HashMap<String, HashMap<String, ItemType>> variations) {
        LinkedHashMap<String, ItemType> r = new LinkedHashMap<String, ItemType>();
        Matcher m = Pattern.compile("\\[([^\\[\\]]+?)\\]").matcher(name);
        if (m.find()) {
            r.putAll(Aliases.getAliases(m.replaceFirst("$1"), value, variations));
            r.putAll(Aliases.getAliases(m.replaceFirst("").replace("  ", " "), value, variations));
        } else {
            m = Pattern.compile("\\(([^\\(\\)]+?)\\)").matcher(name);
            if (m.find()) {
                String[] split = m.group(1).split("\\|");
                if (split.length == 1) {
                    Skript.error(m_brackets_error.toString());
                }
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    r.putAll(Aliases.getAliases(m.replaceFirst(s), value, variations));
                    ++n2;
                }
            } else {
                m = Pattern.compile("\\{(.+?)\\}").matcher(name);
                if (m.find()) {
                    if (variations.get(m.group(1)) != null) {
                        boolean hasDefault = false;
                        for (Map.Entry<String, ItemType> v : variations.get(m.group(1)).entrySet()) {
                            String n;
                            if (v.getKey().equalsIgnoreCase("{default}")) {
                                hasDefault = true;
                                n = m.replaceFirst("").replace("  ", " ");
                            } else {
                                n = m.replaceFirst(v.getKey());
                            }
                            ItemType t = v.getValue().intersection(value);
                            if (t != null) {
                                r.putAll(Aliases.getAliases(n, t, variations));
                                continue;
                            }
                            Skript.warning(m_empty_alias.toString(n));
                        }
                        if (!hasDefault) {
                            r.putAll(Aliases.getAliases(m.replaceFirst("").replace("  ", " "), value, variations));
                        }
                    } else {
                        Skript.error(m_unknown_variation.toString(m.group(1)));
                    }
                } else {
                    r.put(name, value);
                }
            }
        }
        return r;
    }

    static int addAliases(String name, String value, HashMap<String, HashMap<String, ItemType>> variations) {
        ItemType t = Aliases.parseAlias(value);
        if (t == null) {
            return 0;
        }
        HashMap<String, ItemType> as = Aliases.getAliases(name, t, variations);
        boolean printedStartingWithNumberError = false;
        for (Map.Entry<String, ItemType> e : as.entrySet()) {
            ItemType i;
            String s = e.getKey().trim().replaceAll("\\s+", " ");
            Pair<String, String> p = Language.getPlural(s);
            String lcs = ((String)p.first).toLowerCase();
            String lcp = ((String)p.second).toLowerCase();
            if (lcs.matches("\\d+ .*") || lcp.matches("\\d+ .*")) {
                if (printedStartingWithNumberError) continue;
                Skript.error(m_starting_with_number.toString());
                printedStartingWithNumberError = true;
                continue;
            }
            boolean b = lcs.endsWith(" " + itemSingular);
            if (b || lcp.endsWith(" " + itemPlural)) {
                i = aliases.get((b ? lcs : lcp).substring(0, (b ? lcs : lcp).length() - (b ? itemSingular.length() : itemPlural.length()) - 1));
                if (i != null) {
                    i.setItem(e.getValue());
                }
            } else {
                b = lcs.endsWith(" " + blockSingular);
                if (b || lcp.endsWith(" " + blockPlural)) {
                    i = aliases.get((b ? lcs : lcp).substring(0, (b ? lcs : lcp).length() - (b ? blockSingular.length() : blockPlural.length()) - 1));
                    if (i != null) {
                        i.setBlock(e.getValue());
                    }
                } else {
                    i = aliases.get(String.valueOf(lcs) + " " + itemSingular);
                    if (i != null) {
                        e.getValue().setItem(i);
                    } else {
                        e.getValue().setItem(aliases.get(String.valueOf(lcs) + " " + itemPlural));
                    }
                    i = aliases.get(String.valueOf(lcs) + " " + blockSingular);
                    if (i != null) {
                        e.getValue().setBlock(i);
                    } else {
                        e.getValue().setBlock(aliases.get(String.valueOf(lcs) + " " + blockPlural));
                    }
                }
            }
            aliases.put(lcs, e.getValue());
            aliases.put(lcp, e.getValue());
            if (e.getValue().getTypes().size() != 1) continue;
            ItemData d = e.getValue().getTypes().get(0);
            MaterialName n = materialNames.get(d.getId());
            if (d.dataMin == -1 && d.dataMax == -1) {
                if (n != null) {
                    if (!n.singular.equals("" + d.getId()) || !n.singular.equals(n.plural)) continue;
                    n.singular = (String)p.first;
                    n.plural = (String)p.second;
                    continue;
                }
                materialNames.put(d.getId(), new MaterialName(d.getId(), (String)p.first, (String)p.second));
                continue;
            }
            if (n == null) {
                n = new MaterialName(d.getId(), "" + d.getId(), "" + d.getId());
                materialNames.put(d.getId(), n);
            }
            n.names.put(new Pair<Short, Short>(d.dataMin, d.dataMax), p);
        }
        return as.size();
    }

    public static final String getMaterialName(int id, short data, boolean plural) {
        return Aliases.getMaterialName(id, data, data, plural);
    }

    public static final String getDebugMaterialName(int id, short data, boolean plural) {
        return Aliases.getDebugMaterialName(id, data, data, plural);
    }

    public static final String getMaterialName(int id, short dataMin, short dataMax, boolean plural) {
        MaterialName n = materialNames.get(id);
        if (n == null) {
            return "" + id;
        }
        return n.toString(dataMin, dataMax, plural);
    }

    public static final String getDebugMaterialName(int id, short dataMin, short dataMax, boolean plural) {
        MaterialName n = materialNames.get(id);
        if (n == null) {
            return id + ":" + dataMin + (dataMax == dataMin ? "" : "-" + dataMax);
        }
        return n.getDebugName(dataMin, dataMax, plural);
    }

    static final int addMissingMaterialNames() {
        Object m;
        int r = 0;
        StringBuilder missing = new StringBuilder(m_missing_aliases + " ");
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = materialArray[n2];
            if (materialNames.get(m.getId()) == null) {
                materialNames.put(m.getId(), new MaterialName(m.getId(), m.toString().toLowerCase().replace('_', ' '), m.toString().toLowerCase().replace('_', ' ')));
                missing.append(String.valueOf(m.getId()) + ", ");
                ++r;
            }
            ++n2;
        }
        m = materialNames.get(-1);
        if (m == null) {
            materialNames.put(-1, new MaterialName(-1, "anything", "anything"));
            missing.append("<any>, ");
            ++r;
        }
        if (r > 0) {
            Skript.warning(missing.substring(0, missing.length() - 2));
        }
        return r;
    }

    public static ItemType parseAlias(String s) {
        String[] types;
        if (s == null || s.isEmpty()) {
            Skript.error(m_empty_string.toString());
            return null;
        }
        if (s.equals("*")) {
            return everything;
        }
        ItemType t = new ItemType();
        String[] stringArray = types = s.split("\\s*,\\s*");
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (Aliases.parseType(type, t, true) == null) {
                return null;
            }
            ++n2;
        }
        return t;
    }

    public static ItemType parseItemType(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        s = s.trim();
        ItemType t = new ItemType();
        Matcher m = p_of_every.getPattern().matcher(s);
        if (m.matches()) {
            t.setAmount(Utils.parseInt(m.group(1)));
            t.setAll(true);
            s = m.group(m.groupCount());
        } else {
            m = p_of.getPattern().matcher(s);
            if (m.matches()) {
                t.setAmount(Utils.parseInt(m.group(1)));
                s = m.group(m.groupCount());
            } else {
                m = p_every.getPattern().matcher(s);
                if (m.matches()) {
                    t.setAll(true);
                    s = m.group(m.groupCount());
                } else {
                    int l = s.length();
                    if ((s = Noun.stripIndefiniteArticle(s)).length() != l) {
                        t.setAmount(1);
                    }
                }
            }
        }
        String lc = s.toLowerCase();
        String of = Language.getSpaced("enchantments.of").toLowerCase();
        int c = -1;
        block3: while ((c = lc.indexOf(of, c + 1)) != -1) {
            String[] enchs;
            ItemType t2 = t.clone();
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                if (Aliases.parseType(s.substring(0, c), t2, false) == null) {
                    log.stop();
                    continue;
                }
            }
            finally {
                log.stop();
            }
            if (t2.numTypes() == 0) continue;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            String[] stringArray = enchs = lc.substring(c + of.length(), lc.length()).split("\\s*(,|" + Language.get("and") + ")\\s*");
            int n = enchs.length;
            int n2 = 0;
            while (n2 < n) {
                String ench = stringArray[n2];
                EnchantmentType e = EnchantmentType.parse(ench);
                if (e == null) continue block3;
                enchantments.put(e.getType(), e.getLevel());
                ++n2;
            }
            t2.addEnchantments(enchantments);
            return t2;
        }
        if (Aliases.parseType(s, t, false) == null) {
            return null;
        }
        if (t.numTypes() == 0) {
            return null;
        }
        return t;
    }

    private static final ItemType parseType(String s, ItemType t, boolean isAlias) {
        int c = s.indexOf(58);
        if (c == -1) {
            c = s.length();
        }
        String type = s.substring(0, c);
        ItemData data = null;
        if (c != s.length() && (data = Aliases.parseData(s.substring(c + 1))) == null) {
            Skript.error(m_invalid_item_data.toString(s.substring(c)));
            return null;
        }
        if (type.isEmpty()) {
            t.add(data == null ? new ItemData() : data);
            return t;
        }
        if (type.matches("\\d+")) {
            ItemData d = new ItemData(Utils.parseInt(type));
            if (Material.getMaterial((int)d.getId()) == null) {
                Skript.error(m_invalid_id.toString(d.getId()));
                return null;
            }
            if (data != null) {
                if (d.getId() <= 255 && (data.dataMax > 15 || data.dataMin > 15)) {
                    Skript.error(m_invalid_block_data.toString());
                    return null;
                }
                d = d.intersection(data);
            }
            if (!isAlias) {
                Skript.warning("Using an ID instead of an alias is discouraged. " + (d.toString().equals(type) ? "Please crate an alias for '" + type + (type.equals(s) ? "" : " or '" + s + "'") + "' (" + Material.getMaterial((int)d.getId()).name() + ") in aliases.sk or the script's aliases section and use that instead." : "Please replace '" + s + "' with e.g. '" + d.toString(true, false) + "'."));
            }
            t.add(d);
            return t;
        }
        ItemType i = Aliases.getAlias(type);
        if (i != null) {
            for (ItemData d : i) {
                if (data != null) {
                    if (d.getId() <= 255 && (data.dataMax > 15 || data.dataMin > 15)) {
                        Skript.error(m_invalid_block_data.toString());
                        return null;
                    }
                    d = d.intersection(data);
                } else {
                    d = d.clone();
                }
                t.add(d);
            }
            if (data == null) {
                if (i.hasItem()) {
                    t.setItem(i.getItem().clone());
                }
                if (i.hasBlock()) {
                    t.setBlock(i.getBlock().clone());
                }
            }
            return t;
        }
        Skript.error(m_invalid_item_type.toString(s));
        return null;
    }

    private static final ItemType getAlias(String s) {
        ItemType i;
        String lc = s.toLowerCase();
        Matcher m = p_any.getPattern().matcher(lc);
        if (m.matches()) {
            lc = m.group(m.groupCount());
        }
        if ((i = Aliases.getAlias_i(lc)) != null) {
            return i.clone();
        }
        return null;
    }

    private static final ItemData parseData(String s) {
        if (s.isEmpty()) {
            return new ItemData();
        }
        if (!s.matches("\\d+(-\\d+)?")) {
            return null;
        }
        ItemData t = new ItemData();
        int i = s.indexOf(45);
        if (i == -1) {
            i = s.length();
        }
        try {
            t.dataMin = Short.parseShort(s.substring(0, i));
            t.dataMax = i == s.length() ? t.dataMin : Short.parseShort(s.substring(i + 1, s.length()));
        }
        catch (NumberFormatException e) {
            Skript.error(m_out_of_data_range.toString((short)Short.MAX_VALUE));
            return null;
        }
        if (t.dataMin > t.dataMax) {
            Skript.error(m_invalid_range.toString());
            return null;
        }
        return t;
    }

    public static void clear() {
        aliases.clear();
        materialNames.clear();
    }

    public static void load() {
        try {
            aliasConfig = new Config(new File(Skript.getInstance().getDataFolder(), "aliases.sk"), false, true, "=");
        }
        catch (IOException e) {
            Skript.error("Could not load the aliases config: " + e.getLocalizedMessage());
            return;
        }
        final ArrayList aliasNodes = new ArrayList();
        aliasConfig.validate(new SectionValidator().addEntry("aliases", new Setter<String>(){

            @Override
            public void set(String s) {
                String[] stringArray = s.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String n3 = stringArray[n2];
                    aliasNodes.add(n3.trim());
                    ++n2;
                }
            }
        }, false).addEntry("item", new Setter<String>(){

            @Override
            public void set(String s) {
                Pair<String, String> p = Language.getPlural(s);
                itemSingular = ((String)p.first).toLowerCase();
                itemPlural = ((String)p.second).toLowerCase();
            }
        }, false).addEntry("block", new Setter<String>(){

            @Override
            public void set(String s) {
                Pair<String, String> p = Language.getPlural(s);
                blockSingular = ((String)p.first).toLowerCase();
                blockPlural = ((String)p.second).toLowerCase();
            }
        }, false).setAllowUndefinedSections(true));
        for (Node node : aliasConfig.getMainNode()) {
            if (!(node instanceof SectionNode) || aliasNodes.contains(node.getName())) continue;
            Skript.error(m_invalid_section.toString(node.getName()));
        }
        HashMap<String, HashMap<String, ItemType>> variations = new HashMap<String, HashMap<String, ItemType>>();
        int num = 0;
        for (String an : aliasNodes) {
            Node node = aliasConfig.getMainNode().get(an);
            SkriptLogger.setNode(node);
            if (node == null) {
                Skript.error(m_section_not_found.toString(an));
                continue;
            }
            if (!(node instanceof SectionNode)) {
                Skript.error(m_not_a_section.toString(an));
                continue;
            }
            int i = 0;
            for (Node n : (SectionNode)node) {
                if (n instanceof EntryNode) {
                    i += Aliases.addAliases(((EntryNode)n).getKey(), ((EntryNode)n).getValue(), variations);
                    continue;
                }
                if (!(n instanceof SectionNode)) continue;
                if (!n.getName().startsWith("{") || !n.getName().endsWith("}")) {
                    Skript.error(m_unexpected_non_variation_section.toString());
                    continue;
                }
                HashMap<String, ItemType> vs = new HashMap<String, ItemType>();
                for (Node a : (SectionNode)n) {
                    if (a instanceof SectionNode) {
                        Skript.error(m_unexpected_section.toString());
                        continue;
                    }
                    ItemType t = Aliases.parseAlias(((EntryNode)a).getValue());
                    if (t == null) continue;
                    vs.put(((EntryNode)a).getKey(), t);
                }
                variations.put(n.getName().substring(1, n.getName().length() - 1), vs);
            }
            if (Skript.logVeryHigh()) {
                Skript.info(m_loaded_x_aliases_from.toString(i, node.getName()));
            }
            num += i;
        }
        SkriptLogger.setNode(null);
        if (Skript.logNormal()) {
            Skript.info(m_loaded_x_aliases.toString(num));
        }
        Aliases.addMissingMaterialNames();
        if (!SkriptConfig.keepConfigsLoaded.value().booleanValue()) {
            aliasConfig = null;
        }
    }

    private static final class MaterialName {
        private String singular;
        private String plural;
        private final int id;
        private final HashMap<Pair<Short, Short>, Pair<String, String>> names = new HashMap();

        public MaterialName(int id, String singular, String plural) {
            this.id = id;
            this.singular = singular;
            this.plural = plural;
        }

        public String toString(short dataMin, short dataMax, boolean plural) {
            if (this.names == null) {
                return plural ? this.plural : this.singular;
            }
            Pair<String, String> s = this.names.get(new Pair<Short, Short>(dataMin, dataMax));
            if (s != null) {
                return plural ? (String)s.second : (String)s.first;
            }
            if (dataMin == -1 && dataMax == -1 || dataMin == 0 && dataMax == 0) {
                return plural ? this.plural : this.singular;
            }
            s = this.names.get(new Pair<Short, Short>((short)-1, (short)-1));
            if (s != null) {
                return plural ? (String)s.second : (String)s.first;
            }
            return plural ? this.plural : this.singular;
        }

        public String getDebugName(short dataMin, short dataMax, boolean plural) {
            if (this.names == null) {
                return plural ? this.plural : this.singular;
            }
            Pair<String, String> s = this.names.get(new Pair<Short, Short>(dataMin, dataMax));
            if (s != null) {
                return plural ? (String)s.second : (String)s.first;
            }
            if (dataMin == -1 && dataMax == -1 || dataMin == 0 && dataMax == 0) {
                return plural ? this.plural : this.singular;
            }
            return String.valueOf(plural ? this.plural : this.singular) + ":" + (dataMin == -1 ? (short)0 : dataMin) + (dataMin == dataMax ? "" : "-" + (dataMax == -1 ? (this.id <= 255 ? (short)15 : Short.MAX_VALUE) : dataMax));
        }
    }
}

