/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.FormattedMessage;
import ch.njol.skript.localization.Message;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.Version;
import ch.njol.util.ExceptionUtils;
import ch.njol.util.SynchronizedReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public final class Updater {
    private static final String rssURL = "http://dev.bukkit.org/server-mods/skript/files.rss";
    private static final DateFormat RFC2822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    public static final ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
    public static volatile UpdateState state = UpdateState.NOT_STARTED;
    private static final SynchronizedReference<String> error = new SynchronizedReference();
    public static final List<VersionInfo> infos = new ArrayList<VersionInfo>();
    public static final SynchronizedReference<VersionInfo> latest = new SynchronizedReference();
    public static final Message m_not_started = new Message("updater.not started");
    public static final Message m_checking = new Message("updater.checking");
    public static final Message m_check_in_progress = new Message("updater.check in progress");
    public static final FormattedMessage m_check_error = new FormattedMessage("updater.check error", error);
    public static final Message m_running_latest_version = new Message("updater.running latest version");
    public static final Message m_running_latest_version_beta = new Message("updater.running latest version (beta)");
    public static final FormattedMessage m_update_available = new FormattedMessage("updater.update available", latest, Skript.getVersion());
    public static final FormattedMessage m_downloading = new FormattedMessage("updater.downloading", latest);
    public static final Message m_download_in_progress = new Message("updater.download in progress");
    public static final FormattedMessage m_download_error = new FormattedMessage("updater.download error", error);
    public static final FormattedMessage m_downloaded = new FormattedMessage("updater.downloaded", latest);
    public static final Message m_internal_error = new Message("updater.internal error");

    static void check(final CommandSender sender, final boolean download, final boolean isAutomatic) {
        assert (sender != null);
        stateLock.writeLock().lock();
        try {
            if (state != UpdateState.NOT_STARTED && state != UpdateState.CHECK_ERROR) {
                throw new IllegalStateException("Cannot check for an update twice");
            }
            state = UpdateState.CHECK_IN_PROGRESS;
        }
        finally {
            stateLock.writeLock().unlock();
        }
        Skript.info(sender, "" + m_checking);
        new Thread(new Runnable(){

            @Override
            public void run() {
                block53: {
                    InputStream in = null;
                    InputStreamReader r = null;
                    try {
                        try {
                            String message;
                            URLConnection conn = new URL(Updater.rssURL).openConnection();
                            in = conn.getInputStream();
                            r = new InputStreamReader(in, conn.getContentEncoding() == null ? "UTF-8" : conn.getContentEncoding());
                            XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(r);
                            infos.clear();
                            VersionInfo current = null;
                            while (reader.hasNext()) {
                                XMLEvent e = reader.nextEvent();
                                if (e.isStartElement()) {
                                    String element = e.asStartElement().getName().getLocalPart();
                                    if (current == null) {
                                        if (!element.equalsIgnoreCase("item")) continue;
                                        current = new VersionInfo();
                                        continue;
                                    }
                                    if (element.equalsIgnoreCase("title")) {
                                        String version = reader.nextEvent().asCharacters().getData();
                                        if (!version.matches("\\d+\\.\\d+(\\.\\d+)? \\(zip\\)")) {
                                            current = null;
                                            continue;
                                        }
                                        current.version = new Version(version.substring(0, version.length() - " (zip)".length()));
                                        if (current.version.compareTo(Skript.getVersion()) > 0) continue;
                                        break;
                                    }
                                    if (element.equalsIgnoreCase("link")) {
                                        current.pageURL = reader.nextEvent().asCharacters().getData();
                                        continue;
                                    }
                                    if (element.equalsIgnoreCase("description")) {
                                        String cl = "";
                                        while ((e = reader.nextEvent()).isCharacters()) {
                                            cl = String.valueOf(cl) + e.asCharacters().getData();
                                        }
                                        current.changelog = "- " + StringEscapeUtils.unescapeHtml((String)cl).replace("<br>", "").replace("<p>", "").replace("</p>", "").replaceAll("\n(?!\n)", "\n- ");
                                        continue;
                                    }
                                    if (!element.equalsIgnoreCase("pubDate")) continue;
                                    current.date = new Date(RFC2822.parse(reader.nextEvent().asCharacters().getData()).getTime());
                                    continue;
                                }
                                if (!e.isEndElement() || !e.asEndElement().getName().getLocalPart().equalsIgnoreCase("item")) continue;
                                if (current != null) {
                                    infos.add(current);
                                }
                                current = null;
                            }
                            if (!infos.isEmpty()) {
                                Collections.sort(infos, new Comparator<VersionInfo>(){

                                    @Override
                                    public int compare(VersionInfo v1, VersionInfo v2) {
                                        return v2.version.compareTo(v1.version);
                                    }
                                });
                                latest.set(infos.get(0));
                            }
                            String string = infos.isEmpty() ? (Skript.getVersion().isStable() ? "" + m_running_latest_version : "" + m_running_latest_version_beta) : (message = "" + m_update_available);
                            if (isAutomatic && !infos.isEmpty()) {
                                Skript.adminBroadcast(message);
                            } else {
                                Skript.info(sender, message);
                            }
                            if (download && !infos.isEmpty()) {
                                stateLock.writeLock().lock();
                                try {
                                    state = UpdateState.DOWNLOAD_IN_PROGRESS;
                                }
                                finally {
                                    stateLock.writeLock().unlock();
                                }
                                Updater.download_i(sender, isAutomatic);
                                break block53;
                            }
                            stateLock.writeLock().lock();
                            try {
                                state = UpdateState.CHECKED_FOR_UPDATE;
                            }
                            finally {
                                stateLock.writeLock().unlock();
                            }
                        }
                        catch (IOException e) {
                            stateLock.writeLock().lock();
                            try {
                                state = UpdateState.CHECK_ERROR;
                                error.set(ExceptionUtils.toString(e));
                                Skript.error(sender, m_check_error.toString());
                            }
                            finally {
                                stateLock.writeLock().unlock();
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (r != null) {
                                try {
                                    r.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        catch (Exception e) {
                            Skript.error(sender, m_internal_error.toString());
                            Skript.exception((Throwable)e, "Unexpected error while checking for a new version of Skript");
                            stateLock.writeLock().lock();
                            try {
                                state = UpdateState.CHECK_ERROR;
                                error.set(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
                            }
                            finally {
                                stateLock.writeLock().unlock();
                            }
                        }
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }).start();
    }

    private static final String getFileURL(String pageURL) throws MalformedURLException, IOException {
        InputStream in = null;
        try {
            URLConnection conn = new URL(pageURL).openConnection();
            in = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, conn.getContentEncoding() == null ? "UTF-8" : conn.getContentEncoding()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    int e;
                    int s = line.indexOf("<a href=\"http://dev.bukkit.org/media/files/");
                    if (s == -1 || (e = line.indexOf("\">", s + "<a href=\"http://dev.bukkit.org/media/files/".length())) == -1) continue;
                    String string = line.substring(s + "<a href=\"".length(), e);
                    return string;
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new IOException("Could not get the file's URL. You can however download Skript manually from " + pageURL);
    }

    private static final void saveZipEntry(ZipInputStream zip, File file) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(file);
            byte[] buffer = new byte[16384];
            while ((read = zip.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void download_i(CommandSender sender, boolean isAutomatic) {
        assert (sender != null);
        stateLock.readLock().lock();
        try {
            if (state != UpdateState.DOWNLOAD_IN_PROGRESS) {
                throw new IllegalStateException();
            }
        }
        finally {
            stateLock.readLock().unlock();
        }
        Skript.info(sender, "" + m_downloading);
        boolean hasJar = false;
        ZipInputStream zip = null;
        try {
            try {
                ZipEntry entry;
                URLConnection conn = new URL(Updater.getFileURL(Updater.latest.get().pageURL)).openConnection();
                zip = new ZipInputStream(conn.getInputStream());
                boolean hasConfig = false;
                boolean hasAliases = false;
                while ((entry = zip.getNextEntry()) != null) {
                    if (entry.getName().endsWith("Skript.jar")) {
                        assert (!hasJar);
                        Updater.saveZipEntry(zip, new File(Bukkit.getUpdateFolderFile(), "Skript.jar"));
                        hasJar = true;
                    } else if (entry.getName().endsWith("config.sk")) {
                        assert (!hasConfig);
                        Updater.saveZipEntry(zip, new File(Skript.getInstance().getDataFolder(), "config-" + Updater.latest.get().version + ".sk"));
                        hasConfig = true;
                    } else if (entry.getName().endsWith("aliases.sk")) {
                        assert (!hasAliases);
                        Updater.saveZipEntry(zip, new File(Skript.getInstance().getDataFolder(), "aliases-" + Updater.latest.get().version + ".sk"));
                        hasAliases = true;
                    }
                    if (hasJar && hasConfig && hasAliases) break;
                    zip.closeEntry();
                }
                if (isAutomatic) {
                    Skript.adminBroadcast("" + m_downloaded);
                } else {
                    Skript.info(sender, "" + m_downloaded);
                }
                stateLock.writeLock().lock();
                try {
                    state = UpdateState.DOWNLOADED;
                }
                finally {
                    stateLock.writeLock().unlock();
                }
            }
            catch (IOException e) {
                stateLock.writeLock().lock();
                try {
                    state = UpdateState.DOWNLOAD_ERROR;
                    error.set(ExceptionUtils.toString(e));
                    Skript.error(sender, m_download_error.toString());
                }
                finally {
                    stateLock.writeLock().unlock();
                }
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "Error while downloading the latest version of Skript");
                stateLock.writeLock().lock();
                try {
                    state = UpdateState.DOWNLOAD_ERROR;
                    error.set(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
                }
                finally {
                    stateLock.writeLock().unlock();
                }
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void download(final CommandSender sender, final boolean isAutomatic) {
        assert (sender != null);
        stateLock.writeLock().lock();
        try {
            if (state != UpdateState.CHECKED_FOR_UPDATE && state != UpdateState.DOWNLOAD_ERROR) {
                throw new IllegalStateException("Must check for an update first");
            }
            state = UpdateState.DOWNLOAD_IN_PROGRESS;
        }
        finally {
            stateLock.writeLock().unlock();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Updater.download_i(sender, isAutomatic);
            }
        }).start();
    }

    public static enum UpdateState {
        NOT_STARTED,
        CHECK_IN_PROGRESS,
        CHECK_ERROR,
        CHECKED_FOR_UPDATE,
        DOWNLOAD_IN_PROGRESS,
        DOWNLOAD_ERROR,
        DOWNLOADED;

    }

    public static final class VersionInfo {
        Version version;
        String pageURL;
        String changelog;
        Date date;

        public String toString() {
            return this.version.toString();
        }
    }
}

