/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.Updater;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.log.RedirectingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.CommandHelp;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.ChatPaginator;

public class SkriptCommand
implements CommandExecutor {
    private static final CommandHelp skriptCommandHelp = new CommandHelp("<gray>/<gold>skript", "cyan", "skript command").add(new CommandHelp("reload", "red").add("all").add("config").add("aliases").add("scripts").add("<script>")).add(new CommandHelp("enable", "red").add("all").add("<script>")).add(new CommandHelp("disable", "red").add("all").add("<script>")).add(new CommandHelp("update", "red").add("check").add("changes").add("download")).add("help");

    private static final void reloading(CommandSender sender, String what) {
        Skript.info(sender, "Reloading " + what + "...");
    }

    private static final void reloaded(CommandSender sender, RedirectingLogHandler r, String what) {
        if (r.numErrors() == 0) {
            Skript.info(sender, "Successfully reloaded " + what + ".");
        } else {
            Skript.error(sender, "Encountered " + r.numErrors() + " error" + (r.numErrors() == 1 ? "" : "s") + " while reloading " + what + "!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!skriptCommandHelp.test(sender, args)) {
            return true;
        }
        RedirectingLogHandler r = SkriptLogger.startLogHandler(new RedirectingLogHandler(sender, ""));
        try {
            if (args[0].equalsIgnoreCase("reload")) {
                if (args[1].equalsIgnoreCase("all")) {
                    SkriptCommand.reloading(sender, "the config and all scripts");
                    Skript.reload();
                    SkriptCommand.reloaded(sender, r, "the config and all scripts");
                    return true;
                } else if (args[1].equalsIgnoreCase("scripts")) {
                    SkriptCommand.reloading(sender, "all scripts");
                    Skript.reloadScripts();
                    SkriptCommand.reloaded(sender, r, "all scripts");
                    return true;
                } else if (args[1].equalsIgnoreCase("config")) {
                    SkriptCommand.reloading(sender, "the main configuration");
                    Skript.reloadMainConfig();
                    SkriptCommand.reloaded(sender, r, "the main configuration");
                    return true;
                } else if (args[1].equalsIgnoreCase("aliases")) {
                    SkriptCommand.reloading(sender, "the aliases");
                    Skript.reloadAliases();
                    SkriptCommand.reloaded(sender, r, "the aliases");
                    return true;
                } else {
                    File f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        return true;
                    }
                    if (f.getName().startsWith("-")) {
                        Skript.info(sender, "This script is currently disabled. Use <gray>/<gold>skript <cyan>enable <red>" + StringUtils.join(args, " ", 1, args.length) + "<reset> to enable it.");
                        return true;
                    }
                    SkriptCommand.reloading(sender, "<gold>" + f.getName() + "<reset>");
                    ScriptLoader.unloadScript(f);
                    ScriptLoader.loadScripts(new File[]{f});
                    SkriptCommand.reloaded(sender, r, "<gold>" + f.getName() + "<reset>");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("enable")) {
                if (args[1].equals("all")) {
                    try {
                        Skript.info(sender, "Enabling all disabled scripts...");
                        Collection<File> files = SkriptCommand.toggleScripts(true);
                        ScriptLoader.loadScripts(files.toArray(new File[0]));
                        if (r.numErrors() == 0) {
                            Skript.info(sender, "Successfully enabled & parsed all previously disabled scripts.");
                            return true;
                        }
                        Skript.error(sender, "Encountered " + r.numErrors() + " error" + (r.numErrors() == 1 ? "" : "s") + " while parsing disabled scripts!");
                        return true;
                    }
                    catch (IOException e) {
                        Skript.error(sender, "Could not load any scripts (some scripts might have been renamed already and will be enabled when the server restarts): " + e.getLocalizedMessage());
                    }
                    return true;
                }
                File f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                if (f == null) {
                    return true;
                }
                if (!f.getName().startsWith("-")) {
                    Skript.info(sender, "<gold>" + f.getName() + "<reset> is already enabled! Use <gray>/<gold>skript <cyan>reload <red>" + StringUtils.join(args, " ", 1, args.length) + "<reset> to reload it if it was changed.");
                    return true;
                }
                try {
                    FileUtils.move(f, new File(f.getParentFile(), f.getName().substring(1)), false);
                }
                catch (IOException e) {
                    Skript.error(sender, "Could not enable <gold>" + f.getName().substring(1) + "<red>:<reset> " + e.getLocalizedMessage());
                    r.stop();
                    return true;
                }
                f = new File(f.getParentFile(), f.getName().substring(1));
                Skript.info(sender, "Enabling <gold>" + f.getName() + "<red>...");
                ScriptLoader.loadScripts(new File[]{f});
                if (r.numErrors() == 0) {
                    Skript.info(sender, "Successfully enabled & parsed <gold>" + f.getName() + "<reset>.");
                    return true;
                } else {
                    Skript.error(sender, "Encountered " + r.numErrors() + " error" + (r.numErrors() == 1 ? "" : "s") + " while parsing <gold>" + f.getName() + "<red>!");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("disable")) {
                if (args[1].equals("all")) {
                    Skript.disableScripts();
                    try {
                        SkriptCommand.toggleScripts(false);
                        Skript.info(sender, "Successfully disabled all scripts!");
                        return true;
                    }
                    catch (IOException e) {
                        Skript.error(sender, "Could not rename all scripts - some scripts will be enabled again when you restart the server:<reset> " + e.getLocalizedMessage());
                    }
                    return true;
                }
                File f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                if (f == null) {
                    return true;
                }
                if (f.getName().startsWith("-")) {
                    Skript.info(sender, "<gold>" + f.getName().substring(1) + "<reset> is already disabled!");
                    return true;
                }
                ScriptLoader.unloadScript(f);
                try {
                    FileUtils.move(f, new File(f.getParentFile(), "-" + f.getName()), false);
                }
                catch (IOException e) {
                    Skript.error(sender, "Could not rename <gold>" + f.getName() + "<red>, it will be enabled again when you restart the server:<reset> " + e.getLocalizedMessage());
                    r.stop();
                    return true;
                }
                Skript.info(sender, "Successfully disabled <gold>" + f.getName() + "<reset>!");
                return true;
            }
            if (args[0].equalsIgnoreCase("update")) {
                Updater.stateLock.writeLock().lock();
                try {
                    Updater.UpdateState state = Updater.state;
                    if (args[1].equals("check")) {
                        switch (state) {
                            case NOT_STARTED: {
                                Updater.check(sender, false, false);
                                return true;
                            }
                            case CHECK_IN_PROGRESS: {
                                Skript.info(sender, "" + Updater.m_check_in_progress);
                                return true;
                            }
                            case CHECK_ERROR: {
                                Updater.check(sender, false, false);
                                return true;
                            }
                            case CHECKED_FOR_UPDATE: {
                                if (Updater.latest.get() == null) {
                                    Skript.info(sender, Skript.getVersion().isStable() ? "" + Updater.m_running_latest_version : "" + Updater.m_running_latest_version_beta);
                                    return true;
                                }
                                Skript.info(sender, "" + Updater.m_update_available);
                                return true;
                            }
                            case DOWNLOAD_IN_PROGRESS: {
                                Skript.info(sender, "" + Updater.m_download_in_progress);
                                return true;
                            }
                            case DOWNLOAD_ERROR: {
                                Skript.info(sender, "" + Updater.m_download_error);
                                return true;
                            }
                            case DOWNLOADED: {
                                Skript.info(sender, "" + Updater.m_downloaded);
                            }
                            default: {
                                return true;
                            }
                        }
                    } else if (args[1].equalsIgnoreCase("changes")) {
                        if (state == Updater.UpdateState.NOT_STARTED) {
                            Skript.info(sender, "" + Updater.m_not_started);
                            return true;
                        } else if (state == Updater.UpdateState.CHECK_IN_PROGRESS) {
                            Skript.info(sender, "" + Updater.m_check_in_progress);
                            return true;
                        } else if (state == Updater.UpdateState.CHECK_ERROR) {
                            Skript.info(sender, "" + Updater.m_check_error);
                            return true;
                        } else if (Updater.latest.get() == null) {
                            Skript.info(sender, Skript.getVersion().isStable() ? "" + Updater.m_running_latest_version : "" + Updater.m_running_latest_version_beta);
                            return true;
                        } else if (args.length == 2 && Updater.infos.size() != 1) {
                            Skript.info(sender, "There have been " + Updater.infos.size() + " updates since your version:");
                            String versions = Updater.infos.get((int)0).version.toString();
                            int i = Updater.infos.size() - 1;
                            while (i >= 0) {
                                versions = String.valueOf(versions) + ", " + Updater.infos.get((int)i).version.toString();
                                --i;
                            }
                            Skript.message(sender, "  " + versions);
                            Skript.message(sender, "To show the changelog of a version type <gold>/skript update changes <version><reset>");
                            return true;
                        } else {
                            Updater.VersionInfo info = null;
                            int pageNum = 1;
                            if (Updater.infos.size() == 1) {
                                info = Updater.latest.get();
                                if (args.length >= 3 && args[2].matches("\\d+")) {
                                    pageNum = Utils.parseInt(args[2]);
                                }
                            } else {
                                String version = args[2];
                                for (Updater.VersionInfo i : Updater.infos) {
                                    if (!i.version.toString().equals(version)) continue;
                                    info = i;
                                    break;
                                }
                                if (info == null) {
                                    Skript.error(sender, "No changelog for the version <gold>" + version + "<red> available");
                                    return true;
                                }
                                if (args.length >= 4 && args[3].matches("\\d+")) {
                                    pageNum = Utils.parseInt(args[3]);
                                }
                            }
                            ChatPaginator.ChatPage page = ChatPaginator.paginate((String)info.changelog, (int)pageNum, (int)55, (int)8);
                            Skript.info(sender, "<bold><cyan>" + info.version + "<reset> (" + info.date + ") <grey>[page " + pageNum + " of " + page.getTotalPages() + "]");
                            sender.sendMessage(page.getLines());
                            if (pageNum >= page.getTotalPages()) return true;
                            Skript.message(sender, "<gray>type <gold>/skript update changes " + (Updater.infos.size() == 1 ? "" : info.version + " ") + (pageNum + 1) + "<gray> for the next page (hint: use the up arrow key)");
                        }
                        return true;
                    } else {
                        if (!args[1].equalsIgnoreCase("download")) return true;
                        switch (state) {
                            case NOT_STARTED: {
                                Updater.check(sender, true, false);
                                return true;
                            }
                            case CHECK_IN_PROGRESS: {
                                Skript.info(sender, "" + Updater.m_check_in_progress);
                                return true;
                            }
                            case CHECK_ERROR: {
                                Updater.check(sender, true, false);
                                return true;
                            }
                            case CHECKED_FOR_UPDATE: {
                                if (Updater.latest.get() == null) {
                                    Skript.info(sender, Skript.getVersion().isStable() ? "" + Updater.m_running_latest_version : "" + Updater.m_running_latest_version_beta);
                                    return true;
                                }
                                Updater.download(sender, false);
                                return true;
                            }
                            case DOWNLOAD_IN_PROGRESS: {
                                Skript.info(sender, "" + Updater.m_download_in_progress);
                                return true;
                            }
                            case DOWNLOADED: {
                                Skript.info(sender, "" + Updater.m_downloaded);
                                return true;
                            }
                            case DOWNLOAD_ERROR: {
                                Skript.info(sender, "" + Updater.m_download_error);
                            }
                            default: {
                                return true;
                            }
                        }
                    }
                }
                finally {
                    Updater.stateLock.writeLock().unlock();
                }
            }
            if (!args[0].equalsIgnoreCase("help")) return true;
            skriptCommandHelp.showHelp(sender);
            return true;
        }
        finally {
            r.stop();
        }
    }

    private static File getScriptFromArgs(CommandSender sender, String[] args, int start) {
        File f;
        String script = StringUtils.join(args, " ", start, args.length);
        if (!script.endsWith(".sk")) {
            script = String.valueOf(script) + ".sk";
        }
        if (script.startsWith("-")) {
            script = script.substring(1);
        }
        if (!(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + script)).exists() && !(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + "-" + script)).exists()) {
            Skript.error(sender, "Can't find the script <grey>'<gold>" + script + "<grey>'<red> in the scripts folder!");
            return null;
        }
        return f;
    }

    private static final Collection<File> toggleScripts(final boolean enable) throws IOException {
        return FileUtils.renameAll(new File(Skript.getInstance().getDataFolder(), "scripts"), new Converter<String, String>(){

            @Override
            public String convert(String name) {
                if (name.startsWith("-") == enable) {
                    return enable ? name.substring(1) : "-" + name;
                }
                return null;
            }
        });
    }
}

