/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util.iterator;

import ch.njol.util.Checker;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CheckedIterator<T>
implements Iterator<T> {
    private final Iterator<T> iter;
    private final Checker<T> checker;
    private boolean returnedNext = true;
    private T next;

    public CheckedIterator(Iterator<T> iter, Checker<T> checker) {
        this.iter = iter;
        this.checker = checker;
    }

    @Override
    public boolean hasNext() {
        if (!this.returnedNext) {
            return true;
        }
        if (!this.iter.hasNext()) {
            return false;
        }
        this.returnedNext = false;
        while (this.iter.hasNext()) {
            this.next = this.iter.next();
            if (!this.checker.check(this.next)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.returnedNext = true;
        return this.next;
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

