/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Pair;
import java.io.Closeable;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class VariablesStorage
implements Closeable {
    private final LinkedBlockingQueue<Pair<String, Object>> changesQueue = new LinkedBlockingQueue();
    protected boolean closed = false;
    private final Thread writeThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (!VariablesStorage.this.closed) {
                try {
                    Pair<String, String> data2;
                    Pair data = (Pair)VariablesStorage.this.changesQueue.take();
                    Pair<String, String> pair = data2 = data.second == null ? null : Classes.serialize(data.second);
                    if (data2 != null) {
                        VariablesStorage.this.save((String)data.first, (String)data2.first, (String)data2.second);
                        continue;
                    }
                    VariablesStorage.this.save((String)data.first, null, null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    });

    public final boolean load() {
        if (!this.load_i()) {
            return false;
        }
        Skript.closeOnDisable(this);
        this.writeThread.start();
        return true;
    }

    protected abstract boolean load_i();

    final void save(String name, Object value) {
        this.changesQueue.add(new Pair<String, Object>(name, value));
    }

    @Override
    public void close() {
        while (this.changesQueue.size() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.closed = true;
    }

    protected void clearChangesQueue() {
        this.changesQueue.clear();
    }

    protected abstract void save(String var1, String var2, String var3);
}

