/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.variables.DatabaseStorage;
import ch.njol.skript.variables.FlatFileStorage;
import ch.njol.skript.variables.VariablesStorage;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class Variables {
    private static DatabaseStorage database = new DatabaseStorage();
    private static FlatFileStorage file = new FlatFileStorage();
    private static final Comparator<String> variableNameComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            try {
                return (int)Math.signum(Double.parseDouble(s1) - Double.parseDouble(s2));
            }
            catch (NumberFormatException numberFormatException) {
                return s1.compareTo(s2);
            }
        }
    };
    private static final Pattern variableNameSplitPattern = Pattern.compile(Pattern.quote("::"));
    private static final ReadWriteLock variablesLock = new ReentrantReadWriteLock(true);
    private static final TreeMap<String, Object> variables = new TreeMap(variableNameComparator);
    private static final HashMap<String, Object> variablesHashMap = new HashMap();
    private static final HashMap<String, WeakHashMap<Event, Object>> localVariables = new HashMap();

    private Variables() {
    }

    public static boolean load() {
        try {
            variablesLock.writeLock().lock();
            assert (variables.isEmpty());
            assert (variablesHashMap.isEmpty());
            boolean bl = database.load() && file.load();
            return bl;
        }
        finally {
            variablesLock.writeLock().unlock();
        }
    }

    public static final String[] splitVariableName(String name) {
        return variableNameSplitPattern.split(name);
    }

    static SortedMap<String, Object> getVariables() {
        return Collections.unmodifiableSortedMap(variables);
    }

    static Map<String, Object> getVariablesHashMap() {
        return Collections.unmodifiableMap(variablesHashMap);
    }

    static Lock getReadLock() {
        return variablesLock.readLock();
    }

    public static final void setVariable(String name, Object value, VariablesStorage source) {
        try {
            variablesLock.writeLock().lock();
            if (!name.endsWith("*")) {
                if (value == null) {
                    variablesHashMap.remove(name);
                } else {
                    variablesHashMap.put(name, value);
                }
            }
            String[] split = Variables.splitVariableName(name);
            TreeMap<String, Object> parent = variables;
            int i = 0;
            while (i < split.length) {
                String n = split[i];
                TreeMap current = parent.get(n);
                if (current == null) {
                    if (i == split.length - 1) {
                        if (value == null) break;
                        parent.put(n, value);
                        break;
                    }
                    if (value == null) break;
                    current = new TreeMap(variableNameComparator);
                    parent.put(n, current);
                    parent = current;
                } else if (current instanceof TreeMap) {
                    if (i == split.length - 1) {
                        if (value == null) {
                            ((TreeMap)current).remove(null);
                            break;
                        }
                        ((TreeMap)current).put(null, value);
                        break;
                    }
                    if (i == split.length - 2 && split[i + 1].equals("*")) {
                        assert (value == null);
                        Object v = current.get(null);
                        if (v == null) {
                            parent.remove(n);
                            break;
                        }
                        parent.put(n, v);
                        break;
                    }
                    parent = current;
                } else {
                    if (i == split.length - 1) {
                        if (value == null) {
                            parent.remove(n);
                            break;
                        }
                        parent.put(n, value);
                        break;
                    }
                    if (value == null) break;
                    TreeMap c = new TreeMap(variableNameComparator);
                    c.put(null, current);
                    parent.put(n, c);
                    parent = c;
                }
                ++i;
            }
            Variables.saveVariableChange(name, value, source);
        }
        finally {
            variablesLock.writeLock().unlock();
        }
    }

    private static final void saveVariableChange(String name, Object value, VariablesStorage source) {
        if (DatabaseStorage.accept(name)) {
            if (source != database) {
                database.save(name, value);
                if (source == file) {
                    file.save(name, null);
                }
            }
        } else if (source != file) {
            file.save(name, value);
            if (source == database) {
                database.save(name, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object getVariable(String name) {
        try {
            variablesLock.readLock().lock();
            if (!name.endsWith("*")) {
                Object object = variablesHashMap.get(name);
                return object;
            }
            String[] split = Variables.splitVariableName(name);
            TreeMap current = variables;
            int i = 0;
            while (i < split.length) {
                String n = split[i];
                if (n.equals("*")) {
                    assert (i == split.length - 1);
                    SortedMap<String, Object> sortedMap = Collections.unmodifiableSortedMap(current);
                    return sortedMap;
                }
                Object o = current.get(n);
                if (o == null) {
                    return null;
                }
                if (!(o instanceof Map)) return null;
                current = (TreeMap)o;
                assert (i != split.length - 1);
                ++i;
            }
            return null;
        }
        finally {
            variablesLock.readLock().unlock();
        }
    }

    public static final void setLocalVariable(String name, Event e, Object value) {
        WeakHashMap<Object, Object> map = localVariables.get(name);
        if (map == null) {
            map = new WeakHashMap();
            localVariables.put(name, map);
        }
        map.put(e, value);
    }

    public static final Object getLocalVariable(String name, Event e) {
        WeakHashMap<Event, Object> map = localVariables.get(name);
        if (map == null) {
            return null;
        }
        return map.get(e);
    }

    public static int numVariables() {
        try {
            variablesLock.readLock().lock();
            int n = variablesHashMap.size();
            return n;
        }
        finally {
            variablesLock.readLock().unlock();
        }
    }
}

