/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class Task
implements Runnable {
    private final int taskID;

    public Task(JavaPlugin plugin, long delay, long period) {
        this(plugin, delay, period, false);
    }

    public Task(JavaPlugin plugin, long delay, long period, boolean async) {
        this.taskID = async ? (Skript.isRunningMinecraft(1, 4, 6) ? Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, (Runnable)this, delay, period).getTaskId() : Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)plugin, (Runnable)this, delay, period)) : Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)this, delay, period);
    }

    public Task(JavaPlugin plugin, long delay) {
        this(plugin, delay, false);
    }

    public Task(JavaPlugin plugin, long delay, boolean async) {
        this.taskID = async ? (Skript.isRunningMinecraft(1, 4, 6) ? Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, (Runnable)this, delay).getTaskId() : Bukkit.getScheduler().scheduleAsyncDelayedTask((Plugin)plugin, (Runnable)this, delay)) : Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)this, delay);
    }

    public final boolean isAlive() {
        return Bukkit.getScheduler().isQueued(this.taskID) || Bukkit.getScheduler().isCurrentlyRunning(this.taskID);
    }

    public final void cancel() {
        Bukkit.getScheduler().cancelTask(this.taskID);
    }

    public static final <T> T callSync(Callable<T> c) {
        if (Bukkit.isPrimaryThread()) {
            try {
                return c.call();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
        Future f = Bukkit.getScheduler().callSyncMethod((Plugin)Skript.getInstance(), c);
        try {
            while (true) {
                try {
                    return (T)f.get();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (ExecutionException e) {
            Skript.exception((Throwable)e, new String[0]);
        }
        catch (CancellationException cancellationException) {
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
        return null;
    }
}

