/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public abstract class PotionEffectUtils {
    private static final Map<String, PotionEffectType> types = new HashMap<String, PotionEffectType>();
    private static final String[] names = new String[PotionEffectType.values().length];

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                types.clear();
                PotionEffectType[] potionEffectTypeArray = PotionEffectType.values();
                int n = potionEffectTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PotionEffectType t = potionEffectTypeArray[n2];
                    if (t != null) {
                        String[] ls = Language.getList("potions." + t.getName());
                        names[t.getId()] = ls[0];
                        String[] stringArray = ls;
                        int n3 = ls.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String l = stringArray[n4];
                            types.put(l, t);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    private PotionEffectUtils() {
    }

    public static PotionEffectType parse(String s) {
        return types.get(s);
    }

    public static String toString(PotionEffectType t) {
        return names[t.getId()];
    }

    public static short guessData(ThrownPotion p) {
        if (p.getEffects().size() == 1) {
            PotionEffect e = (PotionEffect)p.getEffects().iterator().next();
            Potion d = new Potion(PotionType.getByEffect((PotionEffectType)e.getType())).splash();
            return d.toDamageValue();
        }
        return 0;
    }
}

