/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.classes.SerializableGetter;
import ch.njol.skript.registrations.Converters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.Event;

public class EventValues {
    private static final List<EventValueInfo<?, ?>> defaultEventValues = new ArrayList(30);
    private static final List<EventValueInfo<?, ?>> futureEventValues = new ArrayList();
    private static final List<EventValueInfo<?, ?>> pastEventValues = new ArrayList();

    private EventValues() {
    }

    private static final List<EventValueInfo<?, ?>> getEventValuesList(int time) {
        if (time == -1) {
            return pastEventValues;
        }
        if (time == 0) {
            return defaultEventValues;
        }
        if (time == 1) {
            return futureEventValues;
        }
        throw new IllegalArgumentException("time must be -1, 0, or 1");
    }

    public static <T, E extends Event> void registerEventValue(Class<E> e, Class<T> c, SerializableGetter<T, E> g, int time) {
        EventValues.registerEventValue(e, c, g, time, null, null);
    }

    public static <T, E extends Event> void registerEventValue(Class<E> e, Class<T> c, SerializableGetter<T, E> g, int time, String excludeErrorMessage, Class<? extends E> ... excludes) {
        Skript.checkAcceptRegistrations();
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        int i = 0;
        while (i < eventValues.size()) {
            EventValueInfo<?, ?> info = eventValues.get(i);
            if (info.event.isAssignableFrom(e) && info.event != e || info.event == e && info.c.isAssignableFrom(c)) {
                eventValues.add(i, new EventValueInfo<E, T>(e, c, g, excludeErrorMessage, excludes));
                return;
            }
            ++i;
        }
        eventValues.add(new EventValueInfo<E, T>(e, c, g, excludeErrorMessage, excludes));
    }

    public static <T, E extends Event> T getEventValue(E e, Class<T> c, int time) {
        SerializableGetter<T, ?> g = EventValues.getEventValueGetter(e.getClass(), c, time);
        if (g == null) {
            return null;
        }
        return (T)g.get(e);
    }

    public static final <T, E extends Event> SerializableGetter<? extends T, ? super E> getEventValueGetter(Class<E> e, Class<T> c, int time) {
        return EventValues.getEventValueGetter(e, c, time, true);
    }

    private static final <T, E extends Event> SerializableGetter<? extends T, ? super E> getEventValueGetter(Class<E> e, final Class<T> c, int time, boolean allowDefault) {
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e) || !c.isAssignableFrom(ev.c)) continue;
            if (!EventValues.checkExcludes(ev, e, true)) {
                return null;
            }
            return ev.getter;
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e) || !ev.c.isAssignableFrom(c)) continue;
            if (!EventValues.checkExcludes(ev, e, true)) {
                return null;
            }
            return new SerializableGetter<T, E>(){

                @Override
                public T get(E e) {
                    Object o = ev.getter.get(e);
                    if (c.isInstance(o)) {
                        return o;
                    }
                    return null;
                }
            };
        }
        for (final EventValueInfo<?, ?> ev : eventValues) {
            if (!ev.event.isAssignableFrom(e)) continue;
            if (!EventValues.checkExcludes(ev, e, true)) {
                return null;
            }
            SerializableGetter<T, ?> g = EventValues.getConvertedGetter(ev, c);
            if (g == null) continue;
            return g;
        }
        if (allowDefault && time != 0) {
            return EventValues.getEventValueGetter(e, c, 0);
        }
        return null;
    }

    private static final boolean checkExcludes(EventValueInfo<?, ?> ev, Class<? extends Event> e, boolean printError) {
        if (ev.exculdes == null) {
            return true;
        }
        Class<? extends E>[] classArray = ev.exculdes;
        int n = ev.exculdes.length;
        int n2 = 0;
        while (n2 < n) {
            Class ex = classArray[n2];
            if (ex.isAssignableFrom(e)) {
                if (printError) {
                    Skript.error(ev.excludeErrorMessage);
                }
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static final <E extends Event, F, T> SerializableGetter<? extends T, ? super E> getConvertedGetter(final EventValueInfo<E, F> i, Class<T> to) {
        final SerializableConverter c = Converters.getConverter(i.c, to);
        if (c == null) {
            return null;
        }
        return new SerializableGetter<T, E>(){

            @Override
            public T get(E e) {
                Object f = i.getter.get(e);
                if (f == null) {
                    return null;
                }
                return c.convert(f);
            }
        };
    }

    public static final boolean doesEventValueHaveTimeStates(Class<? extends Event> e, Class<?> c) {
        return EventValues.getEventValueGetter(e, c, -1, false) != null || EventValues.getEventValueGetter(e, c, 1, false) != null;
    }

    private static final class EventValueInfo<E extends Event, T>
    implements Serializable {
        public final Class<E> event;
        public final Class<T> c;
        public final SerializableGetter<T, E> getter;
        public final Class<? extends E>[] exculdes;
        public final String excludeErrorMessage;

        public EventValueInfo(Class<E> event, Class<T> c, SerializableGetter<T, E> getter, String excludeErrorMessage, Class<? extends E>[] exculdes) {
            assert (event != null);
            assert (c != null);
            assert (getter != null);
            this.event = event;
            this.c = c;
            this.getter = getter;
            this.exculdes = exculdes;
            this.excludeErrorMessage = excludeErrorMessage;
        }
    }
}

