/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.localization.Message;
import ch.njol.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Noun
extends Message {
    private String singular;
    private String plural;
    private int gender = 0;
    private static final HashMap<String, Integer> genders = new HashMap();
    private static final List<String> indefiniteArticles = new ArrayList<String>(3);
    private static final List<String> definiteArticles = new ArrayList<String>(3);
    private static String definitePluralArticle = "";

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                String dpa;
                genders.clear();
                indefiniteArticles.clear();
                definiteArticles.clear();
                int i = 0;
                while (i < 100) {
                    String g = Language.localized.get("genders." + i + ".name");
                    if (g == null) break;
                    genders.put(g, i);
                    String ia = Language.localized.get("genders." + i + ".indefinite article");
                    indefiniteArticles.add(ia == null ? "" : ia);
                    String da = Language.localized.get("genders." + i + ".definite article");
                    definiteArticles.add(da == null ? "" : da);
                    ++i;
                }
                if (genders.isEmpty()) {
                    Skript.error("No genders defined in language file " + Language.getName() + ".lang!");
                    indefiniteArticles.add("");
                    definiteArticles.add("");
                }
                definitePluralArticle = (dpa = Language.localized.get("gender.plural.definite article")) == null ? "" : dpa;
            }
        }, Language.LanguageListenerPriority.EARLIEST);
    }

    public Noun(String key) {
        super(key);
    }

    @Override
    protected void onValueChange() {
        String value = this.getValue();
        if (value == null) {
            this.plural = this.singular = this.key;
            this.gender = 0;
            return;
        }
        int g = value.indexOf(64);
        if (g != -1) {
            this.gender = Noun.getGenderID(value.substring(g + 1).trim());
            value = value.substring(0, g).trim();
        } else {
            this.gender = 0;
        }
        Pair<String, String> p = Language.getPlural(value);
        this.singular = (String)p.first;
        this.plural = (String)p.second;
    }

    @Override
    public String toString() {
        this.validate();
        return this.singular;
    }

    public String toString(boolean plural) {
        this.validate();
        return plural ? this.plural : this.singular;
    }

    public String withIndefiniteArticle() {
        this.validate();
        return String.valueOf(indefiniteArticles.get(this.gender).isEmpty() ? "" : String.valueOf(indefiniteArticles.get(this.gender)) + " ") + this.singular;
    }

    public String getIndefiniteArticle() {
        this.validate();
        return indefiniteArticles.get(this.gender);
    }

    public String withDefiniteArticle() {
        this.validate();
        return String.valueOf(definiteArticles.get(this.gender).isEmpty() ? "" : String.valueOf(definiteArticles.get(this.gender)) + " ") + this.singular;
    }

    public String withDefiniteArticle(boolean plural) {
        this.validate();
        return plural ? String.valueOf(definitePluralArticle.isEmpty() ? "" : String.valueOf(definitePluralArticle) + " ") + this.plural : this.withDefiniteArticle();
    }

    public String getDefiniteArticle() {
        this.validate();
        return definiteArticles.get(this.gender);
    }

    public String toString(int amount) {
        this.validate();
        return String.valueOf(amount) + " " + (amount == 1 ? this.singular : this.plural);
    }

    public String toString(double amount) {
        this.validate();
        return String.valueOf(Skript.toString(amount)) + " " + (amount == 1.0 ? this.singular : this.plural);
    }

    public String getSingular() {
        this.validate();
        return this.singular;
    }

    public String getPlural() {
        this.validate();
        return this.plural;
    }

    public static int getGenderID(String gender) {
        Integer i = genders.get(gender);
        if (i != null) {
            return i;
        }
        Skript.warning("Undefined gender '" + gender + "'");
        return 0;
    }
}

