/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.config.Config;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.util.Version;
import ch.njol.util.ExceptionUtils;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;

public class Language {
    private static String name = "english";
    static HashMap<String, String> english = new HashMap();
    static HashMap<String, String> localized = english;
    private static boolean useLocal = false;
    private static HashMap<Plugin, Version> langVersion = new HashMap();
    private static final Pattern split = Pattern.compile("\\s*,\\s*");
    private static final List<LanguageChangeListener> listeners = new ArrayList<LanguageChangeListener>();
    private static final int[] priorityStartIndices = new int[LanguageListenerPriority.values().length];

    public static String getName() {
        return name;
    }

    private static final String get_i(String key) {
        String s;
        if (useLocal && (s = localized.get(key)) != null) {
            return s;
        }
        return english.get(key);
    }

    public static String get(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return key.toLowerCase(Locale.ENGLISH);
        }
        return s;
    }

    public static String get_(String key) {
        return Language.get_i(key.toLowerCase(Locale.ENGLISH));
    }

    public static String format(String key, Object ... args) {
        String value = Language.get_i(key = key.toLowerCase(Locale.ENGLISH));
        if (value == null) {
            return key;
        }
        try {
            return String.format(value, args);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static String getSpaced(String key) {
        String s = Language.get(key.toLowerCase(Locale.ENGLISH));
        if (s.isEmpty()) {
            return " ";
        }
        return " " + s + " ";
    }

    public static String[] getList(String key) {
        String s = Language.get_i(key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return new String[]{key.toLowerCase(Locale.ENGLISH)};
        }
        return split.split(s);
    }

    public static boolean keyExists(String key) {
        return english.containsKey(key.toLowerCase(Locale.ENGLISH));
    }

    public static void loadDefault(SkriptAddon addon) {
        HashMap<String, String> en;
        if (addon.getLanguageFileDirectory() == null) {
            return;
        }
        InputStream din = addon.plugin.getResource(String.valueOf(addon.getLanguageFileDirectory()) + "/english.lang");
        if (din == null) {
            throw new IllegalStateException(String.valueOf(addon.getFile().getName()) + " is missing the required english.lang file!");
        }
        try {
            try {
                en = new Config(din, "english.lang", false, false, ":").toMap(".");
            }
            catch (Exception e) {
                throw Skript.exception((Throwable)e, "Could not load " + addon + "'s default language file!");
            }
        }
        finally {
            try {
                din.close();
            }
            catch (IOException iOException) {}
        }
        langVersion.put((Plugin)addon.plugin, new Version(en.get("version")));
        en.remove("version");
        english.putAll(en);
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    public static boolean load(String name) {
        name = name.toLowerCase();
        localized = new HashMap();
        boolean exists = Language.load(Skript.getAddonInstance(), name);
        for (SkriptAddon addon : Skript.getAddons()) {
            exists |= Language.load(addon, name);
        }
        if (!exists) {
            localized = english;
            Language.name = "english";
            return false;
        }
        Language.name = name;
        Language.validateLocalized();
        if (useLocal) {
            for (LanguageChangeListener l : listeners) {
                l.onLanguageChange();
            }
        }
        return true;
    }

    private static boolean load(SkriptAddon addon, String name) {
        HashMap<String, String> l;
        block10: {
            if (addon.getLanguageFileDirectory() == null) {
                return false;
            }
            l = Language.load(addon.plugin.getResource(String.valueOf(addon.getLanguageFileDirectory()) + "/" + name + ".lang"), name);
            File f = new File(addon.plugin.getDataFolder(), String.valueOf(addon.getLanguageFileDirectory()) + File.separator + name + ".lang");
            try {
                if (f.exists()) {
                    l.putAll(Language.load(new FileInputStream(f), name));
                }
            }
            catch (FileNotFoundException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
        if (l.isEmpty()) {
            return false;
        }
        if (!l.containsKey("version")) {
            Skript.error(addon + "'s language file " + name + ".lang does not provide a version number!");
        } else {
            try {
                Version v = new Version(l.get("version"));
                if (v.isSmallerThan(langVersion.get(addon.plugin))) {
                    Skript.warning(addon + "'s language file " + name + ".lang is outdated, some messages will be english.");
                }
            }
            catch (IllegalArgumentException e) {
                Skript.error("Illegal version syntax in " + addon + "'s language file " + name + ".lang: " + e.getLocalizedMessage());
            }
        }
        l.remove("version");
        localized.putAll(l);
        return true;
    }

    private static HashMap<String, String> load(InputStream in, String name) {
        if (in == null) {
            return new HashMap<String, String>();
        }
        try {
            HashMap<String, String> hashMap = new Config(in, String.valueOf(name) + ".lang", false, false, ":").toMap(".");
            return hashMap;
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, "Could not load the language file '" + name + ".lang': " + ExceptionUtils.toString(e));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            return hashMap;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void validateLocalized() {
        HashSet<String> s = new HashSet<String>(english.keySet());
        s.removeAll(localized.keySet());
        if (!s.isEmpty() && Skript.logNormal()) {
            Skript.error("The following messages have not been translated to " + name + ": " + StringUtils.join(s));
        }
        s = new HashSet<String>(localized.keySet());
        s.removeAll(english.keySet());
        if (!s.isEmpty() && Skript.logHigh()) {
            Skript.warning("The localized language file(s) have superfluous entries: " + StringUtils.join(s));
        }
    }

    public static void addListener(LanguageChangeListener l) {
        Language.addListener(l, LanguageListenerPriority.NORMAL);
    }

    public static void addListener(LanguageChangeListener l, LanguageListenerPriority priority) {
        assert (priority != null);
        listeners.add(priorityStartIndices[priority.ordinal()], l);
        int i = priority.ordinal() + 1;
        while (i < LanguageListenerPriority.values().length) {
            int n = i++;
            priorityStartIndices[n] = priorityStartIndices[n] + 1;
        }
        if (english != null) {
            l.onLanguageChange();
        }
    }

    public static void setUseLocal(boolean b) {
        if (useLocal == b) {
            return;
        }
        useLocal = b;
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    public static Pair<String, String> getPlural(String s) {
        int c = s.indexOf("\u00a6");
        if (c == -1) {
            return new Pair<String, String>(s, s);
        }
        int c2 = s.indexOf("\u00a6", c + 1);
        if (c2 == -1) {
            return new Pair<String, String>(s.substring(0, c), String.valueOf(s.substring(0, c)) + s.substring(c + 1));
        }
        int c3 = s.indexOf("\u00a6", c2 + 1);
        if (c3 == -1) {
            return new Pair<String, String>(String.valueOf(s.substring(0, c)) + s.substring(c + 1, c2), String.valueOf(s.substring(0, c)) + s.substring(c2 + 1));
        }
        return new Pair<String, String>(String.valueOf(s.substring(0, c)) + s.substring(c + 1, c2) + s.substring(c3 + 1), String.valueOf(s.substring(0, c)) + s.substring(c2 + 1, c3) + s.substring(c3 + 1));
    }

    public static enum LanguageListenerPriority {
        EARLIEST,
        NORMAL;

    }
}

