/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.util.StaticGetter;
import ch.njol.util.Reference;

public final class FormattedMessage
extends Message {
    private final Object[] args;

    public FormattedMessage(String key, Object ... args) {
        super(key);
        assert (args.length > 0);
        this.args = args;
    }

    @Override
    public String toString() {
        Object[] args = (Object[])this.args.clone();
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof Reference) {
                args[i] = ((Reference)args[i]).get();
            } else if (args[i] instanceof StaticGetter) {
                args[i] = ((StaticGetter)args[i]).get();
            }
            ++i;
        }
        try {
            return this.getValue() == null ? this.key : String.format(this.getValue(), args);
        }
        catch (IllegalArgumentException e) {
            String m = "The formatted message '" + this.key + "' from the language file '" + Language.getName() + ".lang' uses an illegal format!";
            Skript.adminBroadcast("<red>" + m);
            System.err.println("[Skript] " + m);
            e.printStackTrace();
            return "[ERROR]";
        }
    }
}

