/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.iterator.EmptyIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;

public class Variable<T>
implements Expression<T> {
    public static final String SEPARATOR = "::";
    public static final String LOCAL_VARIABLE_TOKEN = "_";
    private final VariableString name;
    private final Class<T> superType;
    private final Class<? extends T>[] types;
    private final boolean local;
    private final boolean list;
    private final Variable<?> source;

    private Variable(VariableString name, Class<? extends T>[] types, boolean local, boolean list, Variable<?> source) {
        assert (name != null);
        assert (types != null && types.length > 0);
        assert (name.getMode() == StringMode.VARIABLE_NAME);
        this.local = local;
        this.list = list;
        this.name = name;
        this.types = types;
        Class<? extends T> superType = types[0];
        int i = 1;
        while (i < types.length) {
            if (types[i].isAssignableFrom(superType)) {
                superType = types[i];
            }
            ++i;
        }
        this.superType = superType;
        this.source = source;
    }

    public static <T> Variable<T> newInstance(String name, Class<? extends T>[] types) {
        if (name.startsWith(LOCAL_VARIABLE_TOKEN) && name.contains(SEPARATOR)) {
            Skript.error("Local variables cannot be lists, i.e. must not contain the separator '::' (variable: {" + name + "})");
            return null;
        }
        if (name.startsWith(SEPARATOR) || name.endsWith(SEPARATOR)) {
            Skript.error("A variable's name must neither start nor end with the separator '::' (variable: {" + name + "})");
            return null;
        }
        if (name.contains("*") && (name.indexOf("*") != name.length() - 1 || !name.endsWith("::*"))) {
            if (name.indexOf("*") == 0) {
                Skript.error("[1.5] Local variables now start with an underscore: {_local variable} (variable: {" + name + "})");
            } else {
                Skript.error("A variable's name must not contain any asterisks except at the end after the separator '::' to denote a list variable: {variable::*} (variable: {" + name + "})");
            }
            return null;
        }
        if (name.contains("::::")) {
            Skript.error("A variable's name must not contain the separator '::' multiple times in a row (variable: {" + name + "})");
            return null;
        }
        VariableString vs = VariableString.newInstance(name.startsWith(LOCAL_VARIABLE_TOKEN) ? name.substring(LOCAL_VARIABLE_TOKEN.length()) : name, StringMode.VARIABLE_NAME);
        if (vs == null) {
            return null;
        }
        return new Variable<T>(vs, types, name.startsWith(LOCAL_VARIABLE_TOKEN), name.endsWith("::*"), null);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSingle() {
        return !this.list;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e != null) {
            return Classes.toString(this.get(e));
        }
        return "{" + StringUtils.substring(this.name.toString(e, debug), 1, -1) + "}" + (debug ? "(as " + this.superType.getName() + ")" : "");
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> to) {
        return new Variable<T>(this.name, new Class[]{to}, this.local, this.list, this);
    }

    private Object getRaw(Event e) {
        assert (!this.local);
        Object val = Variables.getVariable(this.name.toString(e).toLowerCase());
        if (val == null) {
            return Variables.getVariable(this.name.getDefaultVariableName().toLowerCase());
        }
        return val;
    }

    private Object get(Event e) {
        if (this.local) {
            return Variables.getLocalVariable(this.name.toString(e).toLowerCase(), e);
        }
        Object val = this.getRaw(e);
        if (!this.list) {
            return val;
        }
        if (val == null) {
            return Array.newInstance(this.superType, 0);
        }
        ArrayList l = new ArrayList();
        for (Map.Entry v : ((Map)val).entrySet()) {
            if (v.getKey() == null || v.getValue() == null) continue;
            if (v.getValue() instanceof Map) {
                l.add(((Map)v.getValue()).get(null));
                continue;
            }
            l.add(v.getValue());
        }
        return l.toArray();
    }

    public Iterator<Map.Entry<String, Object>> variablesIterator(Event e) {
        if (!this.list) {
            throw new SkriptAPIException("");
        }
        Object val = this.getRaw(e);
        if (val == null) {
            return new EmptyIterator<Map.Entry<String, Object>>();
        }
        final Iterator iter = ((Map)val).entrySet().iterator();
        return new Iterator<Map.Entry<String, Object>>(){
            private Map.Entry<String, Object> next = null;

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.next == null) ** GOTO lbl6
                return true;
lbl-1000:
                // 1 sources

                {
                    this.next = (Map.Entry)iter.next();
                    if (this.next.getKey() == null || this.next.getValue() == null || this.next.getValue() instanceof Map) continue;
                    return true;
lbl6:
                    // 2 sources

                    ** while (iter.hasNext())
                }
lbl7:
                // 1 sources

                this.next = null;
                return false;
            }

            @Override
            public Map.Entry<String, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry<String, Object> n = this.next;
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<T> iterator(Event e) {
        if (!this.list) {
            throw new SkriptAPIException("");
        }
        Object val = this.getRaw(e);
        if (val == null) {
            return new EmptyIterator();
        }
        final Iterator iter = ((Map)val).entrySet().iterator();
        return new Iterator<T>(){
            private T next = null;

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.next == null) ** GOTO lbl8
                return true;
lbl-1000:
                // 1 sources

                {
                    n = (Map.Entry)iter.next();
                    if (n.getKey() == null || n.getValue() == null || n.getValue() instanceof Map) continue;
                    this.next = Converters.convert(n.getValue(), Variable.access$0(Variable.this));
                    if (this.next == null) continue;
                    return true;
lbl8:
                    // 3 sources

                    ** while (iter.hasNext())
                }
lbl9:
                // 1 sources

                this.next = null;
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object n = this.next;
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    private T getConverted(Event e) {
        assert (!this.list);
        return Converters.convert(this.get(e), this.types);
    }

    private T[] getConvertedArray(Event e) {
        assert (this.list);
        return Converters.convertArray((Object[])this.get(e), this.types, this.superType);
    }

    private final void set(Event e, Object value) {
        if (this.local) {
            Variables.setLocalVariable(this.name.toString(e).toLowerCase(), e, value);
        } else {
            Variables.setVariable(this.name.toString(e).toLowerCase(), value, null);
        }
    }

    private final void setIndex(Event e, String index, Object value) {
        assert (this.list);
        String s = this.name.toString(e).toLowerCase();
        Variables.setVariable(String.valueOf(s.substring(0, s.length() - 1)) + index, value, null);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.list) {
            return Skript.array(Object[].class);
        }
        return Skript.array(Object.class);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        block0 : switch (mode) {
            case CLEAR: {
                this.set(e, null);
                break;
            }
            case SET: {
                ClassInfo<?> ci;
                if (this.list) {
                    this.set(e, null);
                    int i = 1;
                    Object[] objectArray = (Object[])delta;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object d = objectArray[n2];
                        this.setIndex(e, "" + i, d);
                        ++i;
                        ++n2;
                    }
                    break;
                }
                ClassInfo<?> classInfo = ci = delta == null ? null : Classes.getSuperClassInfo(delta.getClass());
                if (ci != null && ci.getSerializeAs() != null) {
                    this.set(e, Converters.convert(delta, ci.getSerializeAs()));
                    break;
                }
                this.set(e, delta);
                break;
            }
            case ADD: 
            case REMOVE: {
                if (delta == null) break;
                if (this.list) {
                    Object[] ds = (Object[])delta;
                    Map o = (Map)this.getRaw(e);
                    if (mode == Changer.ChangeMode.REMOVE) {
                        if (o == null) {
                            return;
                        }
                        for (Map.Entry i : o.entrySet()) {
                            if (!Comparator.Relation.EQUAL.is(Comparators.compare(i.getValue(), delta))) continue;
                            this.setIndex(e, (String)i.getKey(), null);
                            break block0;
                        }
                    } else {
                        int i = 1;
                        Object[] objectArray = ds;
                        int n = ds.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object d = objectArray[n3];
                            if (o != null) {
                                while (o.containsKey("" + i)) {
                                    ++i;
                                }
                            }
                            this.setIndex(e, "" + i, d);
                            ++i;
                            ++n3;
                        }
                    }
                } else {
                    ClassInfo<?> ci;
                    Object o = this.get(e);
                    if ((o == null || o instanceof Number) && delta instanceof Number) {
                        int i = mode == Changer.ChangeMode.ADD ? 1 : -1;
                        this.set(e, (o == null ? 0.0 : ((Number)o).doubleValue()) + (double)i * ((Number)delta).doubleValue());
                        break;
                    }
                    if (o == null || (ci = Classes.getSuperClassInfo(o.getClass())).getChanger() == null || ci.getChanger().acceptChange(mode) == null) break;
                    Class<V>[] cs = ci.getChanger().acceptChange(mode);
                    Object[] one = (Object[])Array.newInstance(o.getClass(), 1);
                    one[0] = o;
                    Class<V>[] classArray = cs;
                    int n = cs.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Class c = classArray[n4];
                        if (c.isAssignableFrom(delta.getClass())) {
                            Changer.ChangerUtils.change(ci.getChanger(), one, delta, mode);
                        } else if (c.isArray() && c.getComponentType().isAssignableFrom(delta.getClass())) {
                            Object[] deltas = (Object[])Array.newInstance(c.getComponentType(), 1);
                            deltas[0] = delta;
                            Changer.ChangerUtils.change(ci.getChanger(), one, deltas, mode);
                        }
                        ++n4;
                    }
                }
                break;
            }
        }
    }

    @Override
    public T getSingle(Event e) {
        if (this.list) {
            throw new SkriptAPIException("Invalid call to getSingle");
        }
        return this.getConverted(e);
    }

    @Override
    public T[] getArray(Event e) {
        return this.getAll(e);
    }

    @Override
    public T[] getAll(Event e) {
        if (this.list) {
            return this.getConvertedArray(e);
        }
        T o = this.getConverted(e);
        if (o == null) {
            return (Object[])Array.newInstance(this.superType, 0);
        }
        Object[] one = (Object[])Array.newInstance(this.superType, 1);
        one[0] = o;
        return one;
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("var") || s.equalsIgnoreCase("variable") || s.equalsIgnoreCase("value") || s.equalsIgnoreCase("index");
    }

    public boolean isIndexLoop(String s) {
        return s.equalsIgnoreCase("index");
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check(this.getAll(e), c, negated, this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.getAll(e), c, false, this.getAnd());
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    @Override
    public Expression<? extends T> simplify() {
        return this;
    }

    static /* synthetic */ Class[] access$0(Variable variable) {
        return variable.types;
    }
}

