/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.ParseLog;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SkriptParser {
    private final String expr;
    private final boolean parseStatic;
    public final ParseContext context;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";
    private static final Pattern varPattern = Pattern.compile("^((the )?var(iable)? )?\\{([^{}]|%\\{|\\}%)+\\}$", 2);
    public static final Pattern listSplitPattern = Pattern.compile("\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*", 2);
    public static final Pattern listElementPattern = Pattern.compile("((?:[^\"{}]|\"(?:[^\"]|\"\")*\"|\\{(?:[^{}]|%\\{|\\}%)+\\})+?)(?:\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*)", 2);

    private SkriptParser(String expr) {
        this(expr, false);
    }

    private SkriptParser(String expr, boolean parseStatic) {
        this(expr, parseStatic, ParseContext.DEFAULT);
    }

    private SkriptParser(String expr, boolean parseStatic, ParseContext context) {
        assert (expr != null);
        this.expr = expr;
        this.parseStatic = parseStatic;
        this.context = context;
    }

    public static final <T> Literal<? extends T> parseLiteral(String expr, Class<T> c, ParseContext context) {
        if ((expr = expr.trim()).isEmpty()) {
            return null;
        }
        return new UnparsedLiteral(expr).getConvertedExpression(context, c);
    }

    public static final <T extends SyntaxElement> T parse(String expr, Iterator<? extends SyntaxElementInfo<T>> source, String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLog log = SkriptLogger.startParseLog();
        T e = new SkriptParser(expr).parse(source);
        log.stop();
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printError(defaultError);
        return null;
    }

    public static final <T extends SyntaxElement> T parseStatic(String expr, Iterator<? extends SyntaxElementInfo<? extends T>> source, String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLog log = SkriptLogger.startParseLog();
        T e = new SkriptParser(expr, true).parse(source);
        log.stop();
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printError(defaultError);
        return null;
    }

    private final <T extends SyntaxElement> T parse(Iterator<? extends SyntaxElementInfo<? extends T>> source) {
        ParseLog log = SkriptLogger.startParseLog();
        while (source.hasNext()) {
            SyntaxElementInfo<? extends T> info = source.next();
            int i = 0;
            while (i < info.patterns.length) {
                block14: {
                    log.clear();
                    try {
                        ParseResult res = this.parse_i(info.patterns[i], 0, 0);
                        if (res == null) break block14;
                        int x = -1;
                        int j = 0;
                        while ((x = SkriptParser.nextUnescaped(info.patterns[i], '%', x + 1)) != -1) {
                            String name;
                            int x2 = SkriptParser.nextUnescaped(info.patterns[i], '%', x + 1);
                            if (res.exprs[j] == null && !(name = info.patterns[i].substring(x + 1, x2)).startsWith("-")) {
                                ExprInfo vi = SkriptParser.getExprInfo(name);
                                DefaultExpression<?> expr = vi.classes[0].getDefaultExpression();
                                if (expr == null) {
                                    throw new SkriptAPIException("The class '" + vi.classes[0].getCodeName() + "' does not provide a default expression. Either allow null (with %-" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (!vi.isPlural[0] && !expr.isSingle()) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is not a single-element expression. Change your pattern to allow multiple elements or make the expression mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (vi.time != 0 && !expr.setTime(vi.time)) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' does not have distinct time states. [pattern: " + info.patterns[i] + "]");
                                }
                                if (!expr.init()) break block14;
                                res.exprs[j] = expr;
                            }
                            x = x2;
                            ++j;
                        }
                        SyntaxElement t = (SyntaxElement)info.c.newInstance();
                        if (t.init(res.exprs, i, ScriptLoader.hasDelayBefore, res)) {
                            log.printLog();
                            return (T)t;
                        }
                    }
                    catch (InstantiationException e) {
                        assert (false);
                    }
                    catch (IllegalAccessException e) {
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError();
                    }
                }
                ++i;
            }
        }
        log.printError(null);
        return null;
    }

    private static final <T> Variable<T> parseVariable(String expr, Class<? extends T>[] returnTypes) {
        if (varPattern.matcher(expr).matches()) {
            return Variable.newInstance(expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125)), returnTypes);
        }
        return null;
    }

    public static final <T> Expression<? extends T> parseExpression(String s, boolean parseStatic, ParseContext context, Class<? extends T> ... types) {
        assert (s != null && context != null && types != null && types.length > 0);
        assert (types.length == 1 || !Utils.contains(types, Object.class));
        if (types.length == 1 && types[0] == Object.class) {
            return new SkriptParser(s, parseStatic, context).parseObjectExpression();
        }
        return new SkriptParser(s, parseStatic, context).parseExpression(types);
    }

    private final <T> Expression<? extends T> parseExpression(Class<? extends T>[] types) {
        assert (!Utils.contains(types, Object.class));
        String lastExpr = this.expr;
        ParseLog log = SkriptLogger.startParseLog();
        Expression<? extends T> r = this.parseSingleExpr(this.expr, true, types);
        if (r != null) {
            log.printLog();
            return r;
        }
        log.clear();
        LinkedList<Expression<? extends T>> ts = new LinkedList<Expression<? extends T>>();
        Matcher m = listSplitPattern.matcher(this.expr);
        int end = this.expr.length();
        int expectedEnd = -1;
        Kleenean and = Kleenean.UNKNOWN;
        boolean last = false;
        boolean isLiteralList = true;
        while (m.find() || (last = !last)) {
            Expression<? extends T> t;
            if (expectedEnd == -1) {
                expectedEnd = last ? this.expr.length() : m.start();
            }
            if ((t = this.parseSingleExpr(lastExpr = this.expr.substring(last ? 0 : m.end(), end), true, types)) != null) {
                isLiteralList &= t instanceof Literal;
                if (!last && m.group(1) != null) {
                    if (and.isUnknown()) {
                        and = Kleenean.get(m.group(1).equalsIgnoreCase("and"));
                    } else if (and != Kleenean.get(m.group(1).equalsIgnoreCase("and"))) {
                        Skript.warning("List has multiple 'and' or 'or', will default to 'and'");
                        and = Kleenean.TRUE;
                    }
                }
                ts.addFirst(t);
                if (last) break;
                end = m.start();
                m.region(0, end);
                continue;
            }
            log.clear();
        }
        if (end != expectedEnd || ts.isEmpty()) {
            log.printError("'" + lastExpr + "' is " + SkriptParser.notOfType(types));
            return null;
        }
        log.printLog();
        if (ts.size() == 1) {
            return (Expression)ts.getFirst();
        }
        if (and.isUnknown()) {
            Skript.warning("List is missing 'and' or 'or', defaulting to 'and'");
        }
        if (isLiteralList) {
            return new LiteralList(ts.toArray(new Literal[ts.size()]), !and.isFalse());
        }
        return new ExpressionList(ts.toArray(new Expression[ts.size()]), !and.isFalse());
    }

    private final Expression<?> parseObjectExpression() {
        if (!this.parseStatic) {
            ParseLog log = SkriptLogger.startParseLog();
            Expression r = this.parseSingleExpr(this.expr, false, Object.class);
            if (r != null) {
                log.printLog();
                return r;
            }
            log.stop();
        }
        ArrayList ts = new ArrayList();
        Matcher m = listElementPattern.matcher(this.expr);
        int start = 0;
        Kleenean and = Kleenean.UNKNOWN;
        boolean last = false;
        boolean isLiteralList = true;
        while (m.lookingAt() || (last = !last)) {
            String sub = last ? this.expr.substring(start) : m.group(1).trim();
            Expression t = this.parseSingleExpr(sub, true, Object.class);
            isLiteralList &= t instanceof Literal;
            if (!last && m.group(2) != null) {
                if (and.isUnknown()) {
                    and = Kleenean.get(m.group(2).equalsIgnoreCase("and"));
                } else if (and != Kleenean.get(m.group(2).equalsIgnoreCase("and"))) {
                    Skript.warning("List has multiple 'and' or 'or', will default to 'and'");
                    and = Kleenean.TRUE;
                }
            }
            ts.add(t);
            if (last) break;
            start = m.end();
            m.region(start, this.expr.length());
        }
        if (ts.size() == 1) {
            return (Expression)ts.get(0);
        }
        if (and.isUnknown()) {
            Skript.warning("List is missing 'and' or 'or', defaulting to 'and'");
        }
        if (isLiteralList) {
            return new LiteralList(ts.toArray(new Literal[ts.size()]), !and.isFalse());
        }
        return new ExpressionList(ts.toArray(new Expression[ts.size()]), !and.isFalse());
    }

    private final <T> Expression<? extends T> parseSingleExpr(String s, boolean parseLiteral, Class<? extends T> ... types) {
        assert (types.length > 0);
        assert (types.length == 1 || !Utils.contains(types, Object.class));
        assert (!this.parseStatic || parseLiteral);
        if (s.isEmpty()) {
            return null;
        }
        ParseLog log = SkriptLogger.startParseLog();
        Variable<? extends T> var = SkriptParser.parseVariable(this.expr, types);
        if (var != null) {
            log.stop();
            if (this.parseStatic) {
                return null;
            }
            log.printLog();
            return var;
        }
        if (log.hasError()) {
            log.printError(null);
            return null;
        }
        log.clear();
        if (!this.parseStatic) {
            Expression<String> e = s.startsWith("\"") && s.endsWith("\"") && (types[0] == Object.class || Utils.contains(types, String.class)) ? VariableString.newInstance(s.substring(1, s.length() - 1)) : (Expression<String>)SkriptParser.parse(s, Skript.getExpressions(types), null);
            if (e != null) {
                log.printLog();
                Class<? extends T>[] classArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<? extends T> t = classArray[n2];
                    Expression<? extends T> r = e.getConvertedExpression(t);
                    if (r != null) {
                        return r;
                    }
                    ++n2;
                }
                return null;
            }
            log.clear();
        }
        if (!parseLiteral) {
            log.stop();
            return null;
        }
        if (types[0] == Object.class) {
            log.stop();
            return new UnparsedLiteral(s);
        }
        Class<? extends T>[] classArray = types;
        int n = types.length;
        int n3 = 0;
        while (n3 < n) {
            Class<? extends T> c = classArray[n3];
            log.clear();
            T t = Classes.parse(s, c, this.context);
            if (t != null) {
                log.printLog();
                return new SimpleLiteral<T>(t, false);
            }
            ++n3;
        }
        log.printError(null);
        return null;
    }

    public static boolean parseArguments(String args, ScriptCommand command, ScriptCommandEvent event) {
        SkriptParser parser = new SkriptParser(args, true, ParseContext.COMMAND);
        ParseResult res = parser.parse_i(command.getPattern(), 0, 0);
        if (res == null) {
            return false;
        }
        List<Argument<?>> as = command.getArguments();
        assert (as.size() == res.exprs.length);
        int i = 0;
        while (i < res.exprs.length) {
            if (res.exprs[i] == null) {
                as.get(i).setToDefault(event);
            } else {
                as.get(i).set(event, res.exprs[i].getArray(event));
            }
            ++i;
        }
        return true;
    }

    public static Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parseEvent(String event, String defaultError) {
        SimpleLog log = SkriptLogger.startSubLog();
        Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> e = new SkriptParser(event, true, ParseContext.EVENT).parseEvent();
        log.stop();
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printErrors(defaultError);
        return null;
    }

    private Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parseEvent() {
        assert (this.context == ParseContext.EVENT);
        assert (this.parseStatic);
        ParseLog log = SkriptLogger.startParseLog();
        for (SkriptEvent.SkriptEventInfo<?> info : Skript.getEvents()) {
            int i = 0;
            while (i < info.patterns.length) {
                block9: {
                    log.clear();
                    try {
                        ParseResult res = this.parse_i(info.patterns[i], 0, 0);
                        if (res != null) {
                            SkriptEvent e = (SkriptEvent)info.c.newInstance();
                            e.init((Literal[])Arrays.copyOf(res.exprs, res.exprs.length, Literal[].class), i, res);
                            log.printLog();
                            return new Pair(info, e);
                        }
                    }
                    catch (InstantiationException e) {
                        assert (false);
                    }
                    catch (IllegalAccessException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
                ++i;
            }
        }
        log.printLog();
        return null;
    }

    private static int nextBracket(String pattern, char closingBracket, char openingBracket, int start) throws MalformedPatternException {
        int n = 0;
        int i = start;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == closingBracket) {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (pattern.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        throw new MalformedPatternException(pattern, "Missing closing bracket '" + closingBracket + "'");
    }

    private static int nextUnescaped(String pattern, char c, int from) {
        int i = from;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int countUnescaped(String pattern, char c) {
        int r = 0;
        int i = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == c) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    private static int nextQuote(String s, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\"') {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
            }
            ++i;
        }
        return -1;
    }

    public static final String notOfType(Class<?> ... cs) {
        if (cs.length == 1) {
            return String.valueOf(Language.get("not")) + " " + Classes.getSuperClassInfo(cs[0]).getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(Classes.getSuperClassInfo(cs[k]).getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    public static final String notOfType(ClassInfo<?> ... cs) {
        if (cs.length == 1) {
            return String.valueOf(Language.get("not")) + " " + cs[0].getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(cs[k].getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    private final ParseResult parse_i(String pattern, int i, int j) {
        while (j < pattern.length()) {
            switch (pattern.charAt(j)) {
                case '[': {
                    ParseLog log0 = SkriptLogger.startParseLog();
                    ParseResult res = this.parse_i(pattern, i, j + 1);
                    if (res != null) {
                        log0.printLog();
                        return res;
                    }
                    log0.clear();
                    j = SkriptParser.nextBracket(pattern, ']', '[', j + 1) + 1;
                    res = this.parse_i(pattern, i, j);
                    if (res == null) {
                        log0.printError(null);
                    } else {
                        log0.printLog();
                    }
                    return res;
                }
                case '(': {
                    ParseLog log = SkriptLogger.startParseLog();
                    int start = j;
                    while (j < pattern.length()) {
                        log.clear();
                        if (j == start || pattern.charAt(j) == '|') {
                            ParseResult res;
                            int j2;
                            int mark = -1;
                            if (j != pattern.length() - 1 && (Character.isDigit(pattern.charAt(j + 1)) || pattern.charAt(j + 1) == '-') && (j2 = pattern.indexOf(166, j + 2)) != -1) {
                                try {
                                    mark = Integer.parseInt(pattern.substring(j + 1, j2));
                                    j = j2;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if ((res = this.parse_i(pattern, i, j + 1)) != null) {
                                log.printLog();
                                if (mark != -1 && res.mark == -1) {
                                    res.mark = mark;
                                }
                                return res;
                            }
                        } else if (pattern.charAt(j) == '(') {
                            j = SkriptParser.nextBracket(pattern, ')', '(', j + 1);
                        } else {
                            if (pattern.charAt(j) == ')') break;
                            if (j == pattern.length() - 1) {
                                throw new MalformedPatternException(pattern, "Missing closing bracket ')'");
                            }
                        }
                        ++j;
                    }
                    log.printError(null);
                    return null;
                }
                case '%': {
                    int i2;
                    if (i == this.expr.length()) {
                        return null;
                    }
                    int end = pattern.indexOf(37, j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "odd number of '%'");
                    }
                    String name = pattern.substring(j + 1, end);
                    ExprInfo vi = SkriptParser.getExprInfo(name);
                    if (end == pattern.length() - 1) {
                        i2 = this.expr.length();
                    } else if (this.expr.charAt(i) == '\"') {
                        i2 = SkriptParser.nextQuote(this.expr, i + 1) + 1;
                        if (i2 == 0) {
                            return null;
                        }
                    } else if (this.expr.charAt(i) == '{') {
                        i2 = VariableString.nextVariableBracket(this.expr, i + 1) + 1;
                        if (i2 == 0) {
                            return null;
                        }
                    } else {
                        i2 = i + 1;
                    }
                    ParseLog log1 = SkriptLogger.startParseLog();
                    while (i2 <= this.expr.length()) {
                        log1.clear();
                        ParseResult res = this.parse_i(pattern, i2, end + 1);
                        if (res != null) {
                            ParseLog log2 = SkriptLogger.startParseLog();
                            int k = 0;
                            while (k < vi.classes.length) {
                                log2.clear();
                                Expression e = SkriptParser.parseExpression(this.expr.substring(i, i2), this.parseStatic, this.context, vi.classes[k].getC());
                                if (e != null) {
                                    log2.stop();
                                    log1.stop();
                                    if (!vi.isPlural[k] && !e.isSingle()) {
                                        if (this.context == ParseContext.COMMAND) {
                                            Skript.error(Commands.m_too_many_arguments.toString(vi.classes[k].getName().getIndefiniteArticle(), vi.classes[k].getName().toString()), ErrorQuality.SEMANTIC_ERROR);
                                            return null;
                                        }
                                        Skript.error("This expression can only accept a single " + vi.classes[k].getName() + ", but multiple are given.", ErrorQuality.SEMANTIC_ERROR);
                                        return null;
                                    }
                                    if (vi.time != 0) {
                                        if (e instanceof Literal) {
                                            return null;
                                        }
                                        if (ScriptLoader.hasDelayBefore == Kleenean.TRUE) {
                                            Skript.error("Cannot use time states after the event has already passed", ErrorQuality.SEMANTIC_ERROR);
                                            return null;
                                        }
                                        if (!e.setTime(vi.time)) {
                                            Skript.error(e + " does not have a " + (vi.time == -1 ? "past" : "future") + " state", ErrorQuality.SEMANTIC_ERROR);
                                            return null;
                                        }
                                    }
                                    log2.printLog();
                                    log1.printLog();
                                    res.exprs[StringUtils.count((String)pattern, (char)'%', (int)0, (int)(j - 1)) / 2] = e;
                                    return res;
                                }
                                ++k;
                            }
                            log2.stop();
                            log1.stop();
                            if (log2.hasError()) {
                                log2.printError(null);
                                return null;
                            }
                            Skript.error("'" + this.expr.substring(i, i2) + "' is " + SkriptParser.notOfType(vi.classes), ErrorQuality.NOT_AN_EXPRESSION);
                            return null;
                        }
                        ++i2;
                    }
                    log1.printError(null);
                    return null;
                }
                case '<': {
                    int end = pattern.indexOf(62, j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "missing closing regex bracket '>'");
                    }
                    ParseLog log2 = SkriptLogger.startParseLog();
                    int i2 = i + 1;
                    while (i2 <= this.expr.length()) {
                        Matcher m;
                        log2.clear();
                        ParseResult res = this.parse_i(pattern, i2, end + 1);
                        if (res != null && (m = Pattern.compile(pattern.substring(j + 1, end)).matcher(this.expr.substring(i, i2))).matches()) {
                            res.regexes.add(0, m.toMatchResult());
                            log2.printLog();
                            return res;
                        }
                        ++i2;
                    }
                    log2.printError(null);
                    return null;
                }
                case ')': 
                case ']': {
                    ++j;
                    break;
                }
                case '|': {
                    j = SkriptParser.nextBracket(pattern, ')', '(', j + 1) + 1;
                    break;
                }
                case ' ': {
                    if (i == 0 || i == this.expr.length() || i > 0 && this.expr.charAt(i - 1) == ' ') {
                        ++j;
                        break;
                    }
                    if (this.expr.charAt(i) != ' ') {
                        return null;
                    }
                    ++i;
                    ++j;
                    break;
                }
                case '\\': {
                    if (++j == pattern.length()) {
                        throw new MalformedPatternException(pattern, "must not end with a backslash");
                    }
                }
                default: {
                    if (i == this.expr.length() || Character.toLowerCase(pattern.charAt(j)) != Character.toLowerCase(this.expr.charAt(i))) {
                        return null;
                    }
                    ++i;
                    ++j;
                }
            }
        }
        if (i == this.expr.length() && j == pattern.length()) {
            return new ParseResult(this, pattern);
        }
        return null;
    }

    private static ExprInfo getExprInfo(String s) throws MalformedPatternException, IllegalArgumentException, SkriptAPIException {
        int a;
        ExprInfo r = new ExprInfo();
        r.isOptional = s.startsWith("-");
        if (r.isOptional) {
            s = s.substring(1);
        }
        if ((a = s.indexOf("@")) != -1) {
            r.time = Integer.parseInt(s.substring(a + 1));
            s = s.substring(0, a);
        }
        String[] classes = s.split("/");
        r.classes = new ClassInfo[classes.length];
        r.isPlural = new boolean[classes.length];
        int i = 0;
        while (i < classes.length) {
            Pair<String, Boolean> p = Utils.getEnglishPlural(classes[i]);
            r.classes[i] = Classes.getClassInfo((String)p.first);
            r.isPlural[i] = (Boolean)p.second;
            ++i;
        }
        return r;
    }

    private static final class ExprInfo {
        ClassInfo<?>[] classes;
        boolean[] isPlural;
        boolean isOptional;
        int time = 0;

        private ExprInfo() {
        }
    }

    private static final class MalformedPatternException
    extends RuntimeException {
        public MalformedPatternException(String pattern, String message) {
            super(String.valueOf(message) + " [pattern: " + pattern + "]");
        }
    }

    public static final class ParseResult {
        public final Expression<?>[] exprs;
        public final List<MatchResult> regexes = new ArrayList<MatchResult>();
        public final String expr;
        public int mark = -1;

        public ParseResult(SkriptParser parser, String pattern) {
            this.expr = parser.expr;
            this.exprs = new Expression[SkriptParser.countUnescaped(pattern, '%') / 2];
        }
    }
}

