/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.regions.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.hooks.regions.RegionsPlugin;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CondCanBuild
extends Condition {
    private Expression<Player> players;
    private Expression<Direction> directions;
    private Expression<Location> locations;

    static {
        Skript.registerCondition(CondCanBuild.class, "%players% can build %directions% %locations%", "%players% can('t|not) build %directions% %locations%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.directions = exprs[1];
        this.locations = exprs[2];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.players.check(e, new Checker<Player>(){

            @Override
            public boolean check(final Player p) {
                return CondCanBuild.this.directions.check(e, new Checker<Direction>(){

                    @Override
                    public boolean check(final Direction d) {
                        return CondCanBuild.this.locations.check(e, new Checker<Location>(){

                            @Override
                            public boolean check(Location l) {
                                return RegionsPlugin.canBuild(p, d.getRelative(l));
                            }
                        }, CondCanBuild.this.isNegated());
                    }
                });
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.players.toString(e, debug)) + " can build " + this.directions.toString() + " " + this.locations.toString(e, debug);
    }
}

