/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.economy.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.hooks.economy.EconomyHook;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Comparators;
import ch.njol.util.StringUtils;

public class Money {
    private final double amount;

    static {
        if (EconomyHook.economy != null) {
            Classes.registerClass(new ClassInfo<Money>(Money.class, "money").user("money").parser(new Parser<Money>(){

                @Override
                public Money parse(String s, ParseContext context) {
                    return Money.parse(s);
                }

                @Override
                public String toString(Money m) {
                    return m.toString();
                }

                @Override
                public String toVariableNameString(Money o) {
                    return "money:" + o.amount;
                }

                @Override
                public String getVariableNamePattern() {
                    return "money:-?\\d+(\\.\\d+)?";
                }
            }));
            Comparators.registerComparator(Money.class, Money.class, new Comparator<Money, Money>(){

                @Override
                public Comparator.Relation compare(Money m1, Money m2) {
                    return Comparator.Relation.get(m1.amount - m2.amount);
                }

                @Override
                public boolean supportsOrdering() {
                    return true;
                }
            });
        }
    }

    public Money(double amount) {
        this.amount = amount;
    }

    public double getAmount() {
        return this.amount;
    }

    public static final Money parse(String s) {
        if (EconomyHook.economy == null) {
            Skript.error("No economy plugin detected");
            return null;
        }
        if (!EconomyHook.plural.isEmpty()) {
            if (StringUtils.endsWithIgnoreCase(s, EconomyHook.plural)) {
                try {
                    double d = Double.parseDouble(s.substring(0, s.length() - EconomyHook.plural.length()).trim());
                    return new Money(d);
                }
                catch (NumberFormatException d) {}
            } else if (StringUtils.startsWithIgnoreCase(s, EconomyHook.plural)) {
                try {
                    double d = Double.parseDouble(s.substring(EconomyHook.plural.length()).trim());
                    return new Money(d);
                }
                catch (NumberFormatException d) {
                    // empty catch block
                }
            }
        }
        if (!EconomyHook.singular.isEmpty()) {
            if (StringUtils.endsWithIgnoreCase(s, EconomyHook.singular)) {
                try {
                    double d = Double.parseDouble(s.substring(0, s.length() - EconomyHook.singular.length()).trim());
                    return new Money(d);
                }
                catch (NumberFormatException d) {}
            } else if (StringUtils.startsWithIgnoreCase(s, EconomyHook.singular)) {
                try {
                    double d = Double.parseDouble(s.substring(EconomyHook.singular.length()).trim());
                    return new Money(d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String toString() {
        return EconomyHook.economy.format(this.amount);
    }
}

